package com.biz.crm.mdm.admin.web.report.terminal.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.terminal.repository.TerminalReportVoRepository;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalContact;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import com.biz.crm.mdm.business.terminal.local.service.TerminalContactService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalClientDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalClientVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalTagVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalClientVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalContactVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalTagVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 终端客户voService实现类
 *
 * @author songjingen
 */
@Slf4j
@Service
public class TerminalClientVoServiceImpl implements TerminalClientVoService {

  @Autowired(required = false)
  private TerminalReportVoRepository terminalReportVoRepository;
  @Autowired(required = false)
  private TerminalContactService terminalContactService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private TerminalTagVoService terminalTagVoService;
  @Autowired(required = false)
  private TerminalSupplyService terminalSupplyService;
  /**
   * 基于数据库执行的数据视图执行内容缓存（最多500毫秒）
   */
  private static volatile Cache<String, Page<TerminalClientVo>> cache = null;

  @Override
  public Page<TerminalClientVo> findChildrenPageByTerminalClientDto(Pageable pageable, TerminalClientDto dto) {
    if (cache == null) {
      synchronized (TerminalClientVoServiceImpl.class) {
        while (cache == null) {
          cache = CacheBuilder.newBuilder()
              .initialCapacity(10000)
              .expireAfterWrite(300, TimeUnit.MILLISECONDS)
              .maximumSize(100000)
              .build();
        }
      }
    }
    String cacheKey = StringUtils.join(pageable.getPageNumber(), pageable.getPageSize(), dto.getTenantCode(), dto.getUserName());
    Page<TerminalClientVo> graph = cache.getIfPresent(cacheKey);
    if (graph == null) {
      graph = findChildrenPageByTerminalClientDtoDB(pageable, dto);
      cache.put(cacheKey, graph);
    }
    return graph;
  }

  private Page<TerminalClientVo> findChildrenPageByTerminalClientDtoDB(Pageable pageable, TerminalClientDto dto) {
    log.info("========== db 查询 findChildrenPageByTerminalClientDto ==========");
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null || CollectionUtils.isEmpty(dto.getAllChildrenPostCodes())) {
      return new Page<>();
    }
    if (StringUtils.isBlank(dto.getTenantCode())) {
      dto.setTenantCode(TenantUtils.getTenantCode());
    }
    long start = System.currentTimeMillis();
    //根据职位信息查询供货关系
    List<TerminalSupply> terminalSupplies = this.terminalSupplyService.findByPositionCodes(Sets.newHashSet(dto.getAllChildrenPostCodes()));
    if (CollectionUtils.isEmpty(terminalSupplies)) {
      return new Page<>();
    }
    //根据职位信息查询数据
    List<String> terminalCodes = terminalSupplies.stream().map(TerminalSupply::getTerminalCode).collect(Collectors.toList());
    dto.setTerminalCodes(terminalCodes);
    Page<TerminalClientVo> page = this.terminalReportVoRepository.findPageByTerminalClientDto(pageable, dto);
    log.info("压测环境-根据条件查询终端数据耗时'" + (System.currentTimeMillis() - start) + "'ms");
    List<TerminalClientVo> records = page.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return new Page<>();
    }
    //组装关联数据
    long start1 = System.currentTimeMillis();
    this.buildTerminalClientVos(records);
    log.info("压测环境-组装终端数据耗时'" + (System.currentTimeMillis() - start1) + "'ms");

    return page;
  }

  /**
   * 组装关联数据
   *
   * @param records
   */
  private void buildTerminalClientVos(List<TerminalClientVo> records) {
    List<String> terminalCodes = records.stream().map(TerminalClientVo::getTerminalCode).collect(Collectors.toList());
    //查看联系人
    List<TerminalContact> terminalContactList = this.terminalContactService.findByTerminalCodes(terminalCodes);
    Map<String, List<TerminalContactVo>> terminalContactVoMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(terminalContactList)) {
      List<TerminalContactVo> terminalContactVos = (List<TerminalContactVo>) this.nebulaToolkitService.copyCollectionByWhiteList(terminalContactList, TerminalContact.class, TerminalContactVo.class,
          HashSet.class, ArrayList.class);
      terminalContactVoMap = terminalContactVos.stream().collect(Collectors.groupingBy(TerminalContactVo::getTerminalCode));
    }
    //查看标签
    Map<String, List<TerminalTagVo>> tagVoMap = new HashMap<>();
    List<TerminalTagVo> tagVos = this.terminalTagVoService.findByTerminalCodes(new HashSet<>(terminalCodes));
    if (!CollectionUtils.isEmpty(tagVos)) {
      tagVoMap = tagVos.stream().collect(Collectors.groupingBy(TerminalTagVo::getTerminalCode));
    }
    //赋值
    for (TerminalClientVo terminalClientVo : records) {
      String terminalCode = terminalClientVo.getTerminalCode();
      terminalClientVo.setContacts(terminalContactVoMap.get(terminalCode));
      terminalClientVo.setTags(tagVoMap.get(terminalCode));
    }
  }
}
