package com.biz.crm.mdm.admin.web.report.terminal.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author sunx
 * @date 2021/11/5
 */
@Data
@ApiModel(value = "终端report信息Vo")
public class TerminalReportVo {

  @ApiModelProperty("id,我关联的时候id为供货关系id，其他情况为终端id")
  private String id;

  @ApiModelProperty("终端编码")
  private String terminalCode;

  @ApiModelProperty("终端名称")
  private String terminalName;

  @ApiModelProperty("终端类型")
  private String terminalType;

  @ApiModelProperty("所属组织编码")
  private String orgCode;

  @ApiModelProperty("所属组织")
  private String orgName;

  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;

  @ApiModelProperty("客户组织编码")
  private String customerOrgName;

  @ApiModelProperty("渠道")
  private String channel;

  @ApiModelProperty("营业执照人名称")
  private String licensePersonName;

  @ApiModelProperty("营业执照注册号")
  private String licenseRegisterNumber;

  @ApiModelProperty("营业执照企业名称")
  private String licenseFirmName;

  @ApiModelProperty("终端地址")
  private String terminalAddress;

  @ApiModelProperty("店招照片")
  private String shopImagePath;

  @ApiModelProperty("终端联系人")
  private List<TerminalContactReportVo> contacts;

  @ApiModelProperty("启用状态")
  private String enableStatus;

  @ApiModelProperty("审核状态")
  private String processStatus;

  @ApiModelProperty("省")
  private String provinceCode;

  @ApiModelProperty("省名称")
  private String provinceName;

  @ApiModelProperty("市")
  private String cityCode;

  @ApiModelProperty("市名称")
  private String cityName;

  @ApiModelProperty("区")
  private String districtCode;

  @ApiModelProperty("区名称")
  private String districtName;

  @ApiModelProperty("职位编码")
  private String positionCode;

  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 流程编号
   */
  @ApiModelProperty("流程编号")
  private String processNumber;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

}
