package com.biz.crm.mdm.admin.web.report.user.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.admin.web.report.user.dto.UserDetailDto;
import com.biz.crm.mdm.admin.web.report.user.service.UserDetailVoService;
import com.biz.crm.mdm.admin.web.report.user.vo.UserDetailExtensionVo;
import com.biz.crm.mdm.admin.web.report.user.vo.UserDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 用户详细信息控制层
 *
 * @author xi.peng
 * @since 2021-11-04 16:47:03
 */
@Slf4j
@Api(tags = "MDM管理后台BOOT：UserDetailVo: 用户详细信息")
@RestController
@RequestMapping(value = {"/v1/adminWeb/userDetail"})
public class UserDetailVoController {

  @Autowired(required = false)
  private UserDetailVoService userDetailVoService;

  /**
   * 查询当前登录用户信息
   *
   * @return Result<List<UserDetailVo>>
   */
  @ApiOperation(value = "根据userName获取用户全部用户职位关联信息")
  @GetMapping(value = {"/findUserPositionByUserName"})
  public Result<List<UserDetailVo>> findUserPositionByUserName(UserDetailDto dto) {
    try {
      List<UserDetailVo> result = this.userDetailVoService.findByUserName(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询当前登录用户信息
   *
   * @return Result<List<UserDetailVo>>
   */
  @ApiOperation(value = "获取当前登录用户的当前职位关联的个人信息详情")
  @GetMapping(value = {"/findDetailByLoginUser"})
  public Result<UserDetailVo> findDetailByLoginUser() {
    try {
      UserDetailVo result = this.userDetailVoService.findDetailByLoginUser();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询当前登录用户信息并包含成本中心和业态业务单元,销售组织
   *
   * @return Result<List<UserDetailVo>>
   */
  @ApiOperation(value = "查询当前登录用户信息并包含成本中心和业态业务单元,销售组织")
  @GetMapping(value = {"/findDetailExtByLoginUser"})
  public Result<UserDetailExtensionVo> findDetailExtByLoginUser() {
    try {
      UserDetailExtensionVo result = this.userDetailVoService.findDetailExtByLoginUser();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
