package com.biz.crm.mdm.admin.web.report.user.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.admin.web.report.user.dto.UserReportDto;
import com.biz.crm.mdm.admin.web.report.user.service.UserReportVoService;
import com.biz.crm.mdm.admin.web.report.user.vo.UserReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户报表(User)表控制层
 *
 * @author xi.peng
 * @since 2021-11-04 16:47:03
 */
@Slf4j
@Api(tags = "MDM管理后台BOOT：UserReportVo: 企业用户列表")
@RestController
@RequestMapping(value = {"/v1/adminWeb/userReport"})
public class UserReportVoController {

  @Autowired(required = false)
  private UserReportVoService userReportVoService;

  /**
   * 查询用户报表
   *
   * @param dto 用户报表参数对象
   * @return Result<List < UserReportVo>>
   */
  @ApiOperation(value = "查询用户报表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<UserReportVo>> findByConditions(@PageableDefault(50) Pageable pageable, UserReportDto dto) {
    try {
      Page<UserReportVo> result = this.userReportVoService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询用户报表
   *
   * @param dto 用户报表参数对象
   * @return Result<List < UserReportVo>>
   */
  @ApiOperation(value = "查询用户报表(组织下级)")
  @GetMapping(value = {"/findChildrenOrAllByConditions"})
  public Result<Page<UserReportVo>> findChildrenOrAllByConditions(@PageableDefault(50) Pageable pageable, UserReportDto dto) {
    try {
      Page<UserReportVo> result = this.userReportVoService.findChildrenOrAllByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过用户编码查询用户报表（包含组织职位）
   *
   * @param userCode 用户编码
   * @return ResultUserReportVo
   */
  @ApiOperation(value = "查询用户报表")
  @GetMapping(value = {"/findByUserCode"})
  public Result<UserReportVo> findByUserCode(@RequestParam("userCode") String userCode) {
    try {
      UserReportVo result = this.userReportVoService.findByUserCode(userCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
