package com.biz.crm.mdm.admin.web.report.user.repository;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.admin.web.report.user.dto.UserRelationDto;
import com.biz.crm.mdm.admin.web.report.user.mapper.UserRelationMapper;
import com.biz.crm.mdm.admin.web.report.user.vo.UserRelationVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Optional;

/**
 * 用户关联信息(repository)
 *
 * @author xi.peng
 * @since 2021-11-04 16:47:02
 */
@Component
public class UserRelationRepository {

  @Autowired(required = false)
  private UserRelationMapper userRelationMapper;

  /**
   * 分页
   *
   * @param dto
   * @return
   */
  public List<UserRelationVo> findByConditions(UserRelationDto dto) {
    dto = Optional.ofNullable(dto).orElse(new UserRelationDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    return this.userRelationMapper.findByConditions(dto);
  }

}
