package com.biz.crm.mdm.admin.web.report.user.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.user.dto.UserReportDto;
import com.biz.crm.mdm.admin.web.report.user.vo.UserReportVo;
import org.springframework.data.domain.Pageable;

/**
 * 用户报表(User)表服务接口
 *
 * @author xi.peng
 * @since 2021-11-04 17:38:46
 */
public interface UserReportVoService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<UserReportVo> findByConditions(Pageable pageable, UserReportDto dto);

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<UserReportVo> findChildrenOrAllByConditions(Pageable pageable, UserReportDto dto);

  /**
   * 通过用户编码查询用户报表（包含组织职位）
   *
   * @param userCode 用户编码
   * @return ResultUserReportVo
   */
  UserReportVo findByUserCode(String userCode);
}
