package com.biz.crm.mdm.admin.web.report.user.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.admin.web.report.user.dto.UserDetailDto;
import com.biz.crm.mdm.admin.web.report.user.repository.UserDetailRepository;
import com.biz.crm.mdm.admin.web.report.user.service.UserDetailVoService;
import com.biz.crm.mdm.admin.web.report.user.vo.UserDetailExtensionVo;
import com.biz.crm.mdm.admin.web.report.user.vo.UserDetailVo;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.user.local.entity.UserEntity;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * 用户详细信息服务实现类
 *
 * @author xi.peng
 * @since 2021-11-04 16:47:03
 */
@Service
public class UserDetailVoServiceImpl implements UserDetailVoService {

    @Autowired(required = false)
    private UserDetailRepository userDetailRepository;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private UserPositionVoService userPositionVoService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private CostCenterService costCenterService;

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Override
    public List<UserDetailVo> findByUserName(UserDetailDto dto) {
        if (StringUtils.isBlank(dto.getUserName())) {
            return null;
        }
        return this.userDetailRepository.findByUserName(dto);
    }

    @Override
    public UserDetailVo findDetailByLoginUser() {
        FacturerUserDetails loginUserDetails = loginUserService.getLoginDetails(FacturerUserDetails.class);
        if (loginUserDetails == null || StringUtils.isBlank(loginUserDetails.getTenantCode()) || StringUtils.isBlank(loginUserDetails.getAccount())) {
            return null;
        }
        List<UserPositionVo> userPositionVos = this.userPositionVoService.findByUserName(loginUserDetails.getTenantCode(), loginUserDetails.getAccount());
        Validate.notEmpty(userPositionVos, "请先给当前用户设置岗位");
        Optional<UserPositionVo> currentFlagVo = userPositionVos.stream()
                .filter(r -> Boolean.TRUE.equals(r.getCurrentFlag()))
                .findFirst();
        Validate.isTrue(currentFlagVo.isPresent(), "请先给当前用户设置当前岗位");
        UserDetailDto dto = new UserDetailDto();
        dto.setUserName(loginUserDetails.getAccount());
        dto.setPostCode(currentFlagVo.get().getPositionCode());
        List<UserDetailVo> userDetailVos = this.findByUserName(dto);
        if (CollectionUtils.isEmpty(userDetailVos)) {
            return null;
        }
        return userDetailVos.get(0);
    }

    /**
     * 查询当前登录用户信息并包含成本中心和业态业务单元
     *
     * @return Result<List < UserDetailVo>>
     */
    @Override
    public UserDetailExtensionVo findDetailExtByLoginUser() {
        FacturerUserDetails loginUserDetails = loginUserService.getLoginDetails(FacturerUserDetails.class);
        if (loginUserDetails == null || StringUtils.isBlank(loginUserDetails.getTenantCode()) || StringUtils.isBlank(loginUserDetails.getAccount())) {
            return null;
        }
        List<UserPositionVo> userPositionVos = this.userPositionVoService.findByUserName(loginUserDetails.getTenantCode(), loginUserDetails.getAccount());
        Validate.notEmpty(userPositionVos, "请先给当前用户设置岗位");
        Optional<UserPositionVo> currentFlagVo = userPositionVos.stream()
                .filter(r -> Boolean.TRUE.equals(r.getCurrentFlag()))
                .findFirst();
        Validate.isTrue(currentFlagVo.isPresent(), "请先给当前用户设置当前岗位");
        UserDetailDto dto = new UserDetailDto();
        dto.setUserName(loginUserDetails.getAccount());
        dto.setPostCode(currentFlagVo.get().getPositionCode());
        List<UserDetailVo> userDetailVos = this.findByUserName(dto);
        if (CollectionUtils.isEmpty(userDetailVos)) {
            return null;
        }
        UserDetailExtensionVo extensionVo = this.nebulaToolkitService.copyObjectByBlankList(userDetailVos.get(0), UserDetailExtensionVo.class, null, null);
        UserEntity user = this.userDetailRepository.findCostByUserCode(extensionVo.getUserCode());
        if (null == user || StringUtils.isBlank(user.getCostCenterCode())) {
            return extensionVo;
        }
        //获取关联成本中心
        CostCenterVo centerVo = costCenterService.findByCode(user.getCostCenterCode());
        if (!Objects.isNull(centerVo)) {
            extensionVo.setCostCenterCode(centerVo.getCostCenterCode());
            extensionVo.setCostCenterName(centerVo.getCostCenterName());
            extensionVo.setCompanyCode(centerVo.getCompanyCode());
            extensionVo.setProfitCenterCode(centerVo.getProfitCenterCode());
            extensionVo.setProfitCenterName(centerVo.getProfitCenterName());
        }
        //获取销售组织，业态和业务单元
        if (StringUtils.isNotBlank(extensionVo.getOrgCode())) {
            OrgVo orgVo = orgVoService.findByOrgCode(extensionVo.getOrgCode());
            if (!Objects.isNull(orgVo) && StringUtils.isNotBlank(orgVo.getSalesOrgCode())) {
                SalesOrgVo salesOrgVo = salesOrgVoService.findBySalesOrgCode(orgVo.getSalesOrgCode());
                if (!Objects.isNull(salesOrgVo)) {
                    extensionVo.setSalesOrgCode(salesOrgVo.getSalesOrgCode());
                    extensionVo.setSalesOrgName(salesOrgVo.getSalesOrgName());
                    extensionVo.setBusinessUnitCode(salesOrgVo.getBusinessUnitCode());
                    extensionVo.setBusinessFormatCode(salesOrgVo.getBusinessFormatCode());
                }
            }
        }
        return extensionVo;
    }

}
