package com.biz.crm.mdm.admin.web.report.user.service.internal;

import com.biz.crm.mdm.admin.web.report.user.dto.UserRelationDto;
import com.biz.crm.mdm.admin.web.report.user.repository.UserRelationRepository;
import com.biz.crm.mdm.admin.web.report.user.service.UserRelationVoService;
import com.biz.crm.mdm.admin.web.report.user.vo.UserRelationVo;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 用户关联信息服务实现类
 *
 * @author xi.peng
 * @since 2021-11-04 16:47:03
 */
@Service
public class UserRelationVoServiceImpl implements UserRelationVoService {

  @Autowired(required = false)
  private UserRelationRepository userRelationRepository;

  @Autowired(required = false)
  private PositionVoService positionVoService;

  @Override
  public List<UserRelationVo> findByConditions(UserRelationDto dto) {
    List<UserRelationVo> userRelationVos = this.userRelationRepository.findByConditions(dto);
    if (CollectionUtils.isEmpty(userRelationVos)) {
      return new ArrayList<>();
    }
    // 根据职位编码获取角色列表
    List<String> positionCodes = userRelationVos.stream().filter(p->StringUtils.isNotBlank(p.getPositionCode())).map(UserRelationVo::getPositionCode).distinct().collect(Collectors.toList());
    if (CollectionUtils.isEmpty(positionCodes)) {
      return userRelationVos;
    }
    List<PositionVo> positionVos = this.positionVoService.findByIdsOrCodes(null, positionCodes);
    if (CollectionUtils.isEmpty(positionVos)) {
      return userRelationVos;
    }
    Map<String, PositionVo> positionMap = positionVos.stream().collect(Collectors.toMap(PositionVo::getPositionCode, v -> v));
    userRelationVos.forEach(vo->{
      // 因考虑oracle数据库sql兼容问题，改造原来的sql字段拼接语句：concat(ifnull(o.org_name,''),'/',ifnull(p.position_name,''),'/',ifnull(u.full_name,'' )) union_name,
      List<String> unionList = new ArrayList<>(3);
      if (StringUtils.isNotBlank(vo.getOrgName())) {
        unionList.add(vo.getOrgName());
      }
      if (StringUtils.isNotBlank(vo.getPositionName())) {
        unionList.add(vo.getPositionName());
      }
      if (StringUtils.isNotBlank(vo.getFullName())) {
        unionList.add(vo.getFullName());
      }
      if (CollectionUtils.isNotEmpty(unionList)) {
        vo.setUnionName(StringUtils.join(unionList, "/"));
      }

      if (StringUtils.isBlank(vo.getPositionCode())) {
        return;
      }
      PositionVo positionVo = positionMap.get(vo.getPositionCode());
      if (positionVo == null || CollectionUtils.isEmpty(positionVo.getRoleList())) {
        return;
      }
      vo.setRoleCodeList(positionVo.getRoleList());
    });
    return userRelationVos;
  }

}
