package com.biz.crm.mdm.admin.web.report.user.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.bizunited.nebula.rbac.sdk.vo.RoleVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 用户关联信息VO
 *
 * @author pengxi
 * @date 2020-11-17 20:23:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户关联信息VO")
public class UserRelationVo extends TenantFlagOpVo {

    /**
     * 职位编码
     */
    @ApiModelProperty("职位编码")
    private String positionCode;

    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称")
    private String positionName;

    /**
     * 关联组织编码
     */
    @ApiModelProperty("关联组织编码")
    private String orgCode;

    /**
     * 上级职位编码
     */
    @ApiModelProperty("上级职位编码")
    private String parentCode;

    /**
     * 上级职位名称
     */
    @ApiModelProperty("上级职位名称")
    private String parentName;

    /**
     * 职位级别编码
     */
    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    /**
     * 是否主职位：true 是，false 否
     */
    @ApiModelProperty("是否主职位1是0否")
    private Boolean primaryFlag;

    /**
     * 是否当前职位：true 是，false 否
     */
    @ApiModelProperty("是否当前职位1是0否")
    private Boolean currentFlag;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String orgName;

    /**
     * 职位级别名称
     */
    @ApiModelProperty("职位级别名称")
    private String positionLevelName;

    /**
     * 用户登录名
     */
    @ApiModelProperty("用户登录名")
    private String userName;

    /**
     * 用户姓名
     */
    @ApiModelProperty("用户姓名")
    private String fullName;

    /**
     * 组织名称/职位名称/用户名称
     */
    @ApiModelProperty("组织名称/职位名称/用户名称")
    private String unionName;

    /**
     * 是否新增操作
     */
    @ApiModelProperty("是否新增操作")
    private Boolean operationType;

    /**
     * 用户头像url
     */
    @ApiModelProperty("用户头像url")
    private String userHeadUrl;

    /**
     * 关联角色
     */
    @ApiModelProperty("关联角色")
    private List<String> roleCodeList;

}