package com.biz.crm.mdm.admin.web.report.user.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 用户报表vo
 *
 * @author xi.peng
 * @since 2021-11-04 17:40:54
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户报表Vo")
public class UserReportVo extends TenantFlagOpVo {

  /**
   * 用户账号登录信息
   */
  @ApiModelProperty("用户账号登录信息")
  private String userName;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 用户类型
   */
  @ApiModelProperty("用户类型")
  private String userType;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String fullName;

  /**
   * 性别
   */
  @ApiModelProperty("性别")
  private String gender;

  /**
   * 电话
   */
  @ApiModelProperty("电话")
  private String userPhone;

  /**
   * 生效时间
   */
  @ApiModelProperty("生效时间")
  private String endTime;

  /**
   * 失效时间
   */
  @ApiModelProperty("失效时间")
  private String startTime;

  /**
   * 邮箱
   */
  @ApiModelProperty("邮箱")
  private String email;

  /**
   * 锁定状态 003/009
   */
  @ApiModelProperty("锁定状态 003/009")
  private String lockState;

  /**
   * 最后一次登录时间
   */
  @ApiModelProperty("最后一次登录时间")
  private String lastLoginTime;

  /**
   * 用户头像url
   */
  @ApiModelProperty("用户头像url")
  private String userHeadUrl;

  /**
   * 是否强制修改密码：true 是，false 否
   */
  @ApiModelProperty("是否强制修改密码")
  private Boolean forceChangePassword;

  /**
   * 工号
   */
  @ApiModelProperty("工号")
  private String jobCode;

  /**
   * 员工类型
   */
  @ApiModelProperty("员工类型")
  private String employeeType;

  /**
   * 员工状态
   */
  @ApiModelProperty("员工状态")
  private String employeeStatus;

  /**
   * 身份证号码
   */
  @ApiModelProperty("身份证号码")
  private String identityCardNumber;

  /**
   * 身份证地址
   */
  @ApiModelProperty("身份证地址")
  private String identityCardAddress;

  /**
   * 民族
   */
  @ApiModelProperty("民族")
  private String nationality;

  /**
   * 现住址
   */
  @ApiModelProperty("现住址")
  private String currentAddress;

  /**
   * 政治面貌
   */
  @ApiModelProperty("政治面貌")
  private String politicalAffiliation;

  /**
   * 每隔三个月修改密码更新时间
   */
  @ApiModelProperty("每隔三个月修改密码更新时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date updatePasswordDate;

  /**
   * 设备码
   */
  @ApiModelProperty("设备码")
  private String registrationId;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位编码（用于查询角色）
   */
  @ApiModelProperty("职位编码（用于查询角色）")
  private String rolePositionCode;

  /**
   * 上级用户名称
   */
  @ApiModelProperty("上级用户名称")
  private String parentUserName;

  /**
   * 上级用户全名
   */
  @ApiModelProperty("上级用户全名")
  private String parentFullName;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 职位层级编码
   */
  @ApiModelProperty("职位层级编码")
  private String positionLevelCode;

  /**
   * 职位层级名称
   */
  @ApiModelProperty("职位层级名称")
  private String positionLevelName;


  /**
   * 组织规则编码
   */
  @ApiModelProperty("组织规则编码")
  private String ruleCode;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 角色编码
   */
  @ApiModelProperty("角色编码")
  private String roleCode;

  /**
   * 角色名称
   */
  @ApiModelProperty("角色名称")
  private String roleName;

  /**
   * 角色集合
   */
  @ApiModelProperty("角色集合")
  private List<RoleVo> roles;

}

