package com.biz.crm.mdm.admin.web.service;

import com.biz.crm.mdm.admin.web.dto.ResetPasswordDto;

/**
 * 重置密码服务接口
 *
 * @author pengxi
 */
public interface ResetPasswordService {

  /**
   * 根据手机号和短信验证码修改密码
   *
   * @param appType 设备端类型
   * @param phone 手机号
   * @param password 密码
   * @param verificationCode 短信验证码
   */
  void updatePasswordByPhoneAndVerificationCode(Integer appType, String phone, String password, String verificationCode);

  /**
   * 在登录状态中更改密码
   * @param resetPasswordDto
   */
  void updatePasswordInLoginStatus(ResetPasswordDto resetPasswordDto);
}