package com.biz.crm.mdm.admin.web.service.internal;

import com.biz.crm.business.common.sdk.enums.LoginFromTypeEnum;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import com.biz.crm.mdm.admin.web.service.SmsVerificationCodeService;
import com.biz.crm.mdm.admin.web.strategy.LoginUserManageStrategy;
import com.bizunited.nebula.common.service.sms.SmsService;
import com.bizunited.nebula.common.service.sms.SmsTypeEnums;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 业务侧短信服务实现
 *
 * @author pengxi
 */
@Service
public class SmsVerificationCodeServiceImpl implements SmsVerificationCodeService {

  @Autowired(required = false)
  private ValiditySmsCodeService validitySmsCodeService;

  @Autowired(required = false)
  private SmsService smsService;

  @Autowired(required = false)
  private List<LoginUserManageStrategy> loginFromTypeStrategies;

  /**
   * 根据业务系统类型+登录手机号检查用户有效性
   */
  private void verificationByPhone(Integer appType, String phone) {
    // 检查业务系统类型
    LoginFromTypeEnum loginFromTypeEnum = LoginFromTypeEnum.getEnumByAppType(appType);
    Validate.notNull(loginFromTypeEnum, "业务系统类型未知！");
    // 根据手机号校验用户有效性
    LoginUserManageStrategy strategy = this.loginFromTypeStrategies.stream().filter(a -> loginFromTypeEnum.equals(a.loginFromTypeEnum())).findFirst().orElse(null);
    Validate.notNull(strategy, "未匹配到当前标识业务系统类型【%s】的校验策略！", loginFromTypeEnum.getDesc());
    strategy.verificationByPhone(phone);
  }

  @Override
  public void phoneLoginVerificationCode(Integer appType, String phone) {
    // 根据业务系统类型+登录手机号检查用户有效性
    this.verificationByPhone(appType, phone);
    // 校验完毕，发送短信验证码
    String verificationCode = this.generateVerificationCode();
    this.validitySmsCodeService.setVerificationCodeValidityPeriod(phone, verificationCode);
    String content = "{\"code\":\"" + verificationCode + "\"}";
    this.smsService.sendSms(phone,"SMS_136420112", content, SmsTypeEnums.INFO);
  }

  @Override
  public void retrievePasswordVerificationCode(Integer appType, String phone) {
    // 根据业务系统类型+登录手机号检查用户有效性
    this.verificationByPhone(appType, phone);
    // 校验完毕，发送短信验证码
    String verificationCode = this.generateVerificationCode();
    this.validitySmsCodeService.setVerificationCodeValidityPeriod(phone, verificationCode);
    String content = "{\"code\":\"" + verificationCode + "\"}";
    this.smsService.sendSms(phone,"SMS_136420109",content, SmsTypeEnums.INFO);
  }
}
