package com.biz.crm.mdm.admin.web.service.internal;

import cn.hutool.core.net.UserPassAuthenticator;
import cn.hutool.core.util.StrUtil;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.admin.web.service.SsoUserService;
import com.biz.crm.mdm.business.user.local.service.UserService;
import com.biz.crm.mdm.business.user.sdk.dto.UserForceChangePasswordDto;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.mn.third.system.office.automation.sdk.service.OaSsoService;
import com.biz.crm.mn.third.system.office.automation.sdk.vo.request.OASsoGetUserRequestVo;
import com.biz.crm.mn.third.system.office.automation.sdk.vo.response.OASsoGetUserResponseVo;
import com.bizunited.nebula.security.local.loginform.SimpleLoginFormDetails;
import com.bizunited.nebula.security.local.utils.JwtUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class SsoUserServiceImpl implements SsoUserService {

    @Resource
    private OaSsoService oaSsoService;

    @Resource
    private SimpleSecurityProperties simpleSecurityProperties;

    @Resource
    private LoginUserService loginUserService;

    @Resource
    private UserVoService userVoService;


    @Override
    public String getSsoUserByTicketId(String ticketId) {
        OASsoGetUserRequestVo oaSsoGetUserRequestVo  = new OASsoGetUserRequestVo();
        oaSsoGetUserRequestVo.setTicket(ticketId);

        String propertiesSecretKey = simpleSecurityProperties.getSecretKey();
        OASsoGetUserResponseVo ssoUser = oaSsoService.getSsoUser(oaSsoGetUserRequestVo);
        if (ssoUser == null  || StrUtil.isEmpty(ssoUser.getUserId())){
            return StrUtil.EMPTY;
        }
        UserVo userName = userVoService.findByUserName(ssoUser.getUserName());
//        SimpleLoginFormDetails();
        ssoUser.getUserId();
        return null;
    }


}
