package com.biz.crm.mdm.admin.web.strategy;

import com.biz.crm.business.common.sdk.enums.LoginFromTypeEnum;

/**
 * 各种业务系统的登录账号信息管理策略接口
 *
 * @author pengxi
 */
public interface LoginUserManageStrategy {

  /**
   * 标识业务系统类型
   * @return LoginFromTypeEnum
   */
  LoginFromTypeEnum loginFromTypeEnum();

  /**
   * 根据手机号和短信验证码修改密码
   *
   * @param phone 手机号
   * @param password 密码
   * @param verificationCode 短信验证码
   */
  void updatePasswordByPhoneAndVerificationCode(String phone, String password, String verificationCode);

  /**
   * 根据手机号校验用户有效性
   *
   * 1、用户手机号在对应的用户表中是否存在
   * 2、手机号对应用户是否禁用
   * 3、手机号对应用户是否逻辑删除
   * 4、手机号对应用户账号是否过期
   * 5、手机号对应用户账号关联职位是否变更
   *
   * @param phone 手机号
   */
  void verificationByPhone(String phone);
}