package com.biz.crm.mdm.admin.web.strategy.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.admin.web.config.constant.ConfigConstant;
import com.biz.crm.mdm.admin.web.strategy.FirstLoginChangePasswordStrategy;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 描述：</br>默认第一次登陆强制修改密码策略
 *
 * @author jerry7
 * @date 2022/12/08
 */
@Component
@Slf4j
public class FirstLoginChangePasswordDefaultStrategy implements FirstLoginChangePasswordStrategy {

  /**
   * 密码距离上一次修改后过期天数
   */
  @Value("${password.firstLoginChangePassword:true}")
  private boolean firstLoginChangePassword;

  @Autowired
  private UserVoService userVoService;

  @Override
  public void handle(UserIdentity userIdentity, JSONObject jsonObject) {
    jsonObject.put(ConfigConstant.DICT_FIRST_FORCE_CHANGE_PASSWORD, false);
    if (StringUtils.isBlank(userIdentity.getAccount()) || !firstLoginChangePassword) {
      log.warn("login limit found user account null");
      return;
    }
    UserVo userVo = this.userVoService.findByUserName(userIdentity.getAccount());
    if (ObjectUtils.isEmpty(userVo)) {
      return;
    }
    if (ObjectUtils.isEmpty(userVo.getUpdatePasswordDate())) {
      jsonObject.put(ConfigConstant.DICT_FIRST_FORCE_CHANGE_PASSWORD, true);
      return;
    }
    //获取是否需要首次更新密码
    jsonObject.put(ConfigConstant.DICT_FIRST_FORCE_CHANGE_PASSWORD, userVo.getForceChangePassword());
  }

  @Override
  public int getOrder() {
    return Integer.MIN_VALUE + 100;
  }
}
