package com.biz.crm.mdm.admin.web.strategy.internal;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.admin.web.config.constant.ConfigConstant;
import com.biz.crm.mdm.admin.web.strategy.PasswordOverdueStrategy;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * 描述：</br>密码过期策略-运行登陆
 *
 * @author jerry7
 * @date 2022/12/08
 */
@Component
@Slf4j
public class PasswordOverdueAllowLoginStrategy implements PasswordOverdueStrategy {


  /**
   * 密码距离上一次修改后过期天数
   */
  @Value("${password.overdue.overdueDays:90}")
  private int overdueDays;

  /**
   * 密码过期提前提醒天数
   */
  @Value("${password.overdue.remindDays:5}")
  private int remindDays;

  @Autowired
  private UserVoService userVoService;

  @Override
  public void handle(String userName, JSONObject jsonObject) {
    if (StringUtils.isBlank(userName) || overdueDays == 0 || ObjectUtils.isEmpty(jsonObject)) {
      return;
    }
    jsonObject.put(ConfigConstant.DICT_PASSWORD_FORCE_CHANGE_PASSWORD, false);
    UserVo userVo = this.userVoService.findByUserName(userName);
    if (ObjectUtils.isEmpty(userVo) || ObjectUtils.isEmpty(userVo.getUpdatePasswordDate())) {
      return;
    }
    //获取更新时间差值
    long daysOffset = DateUtil.betweenDay(new Date(), userVo.getUpdatePasswordDate(), true);
    if (daysOffset >= overdueDays) {
      jsonObject.put(ConfigConstant.DICT_PASSWORD_FORCE_CHANGE_PASSWORD, true);
      return;
    }
    //验证是否过期提醒
    if (ObjectUtils.isNotEmpty(jsonObject) && (overdueDays - daysOffset) <= remindDays) {
      jsonObject.put(ConfigConstant.DICT_PASSWORD_CHANGE_REMIND, "您的密码还有" + (overdueDays - daysOffset) + "天过期，请及时修改！");
    }

  }

  @Override
  public String name() {
    return "allowLogin";
  }

  @Override
  public int getOrder() {
    return Integer.MIN_VALUE + 100;
  }
}
