package com.biz.crm.mdm.admin.web.config;

import com.biz.crm.business.common.sdk.model.AbstractLoginUser;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * 为CRM系统请求提供默认对象
 *
 * @author pengxi
 */
@Primary
@Component("authenticationDetailsSource")
public class DefaultAuthenticationDetailsSource implements AuthenticationDetailsSource<HttpServletRequest, AbstractLoginUser> {

  @Override
  public AbstractLoginUser buildDetails(HttpServletRequest context) {
    return new LoginUserDetails(context);
  }

}