package com.biz.crm.mdm.admin.web.config;

import com.biz.crm.mdm.admin.web.filter.LoginLimitFilter;
import com.bizunited.nebula.security.sdk.config.NebulaWebSecurityConfigurerAdapter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

/**
 * 描述：</br>登录错误处理拦截器配置类
 *
 * @author keller
 * @date 2022/10/19
 */
@Configuration
@Slf4j
public class LoginLimitConfig implements NebulaWebSecurityConfigurerAdapter {

  @Bean
  public LoginLimitFilter buildLoginLimitFilter() {
    LoginLimitFilter loginLimitFilter = new LoginLimitFilter();
    return loginLimitFilter;
  }

  @Override
  public void configure(HttpSecurity http) throws Exception {
    log.debug("add login limit filter success");
    http.addFilterBefore(buildLoginLimitFilter(), UsernamePasswordAuthenticationFilter.class);
  }
}
