package com.biz.crm.mdm.admin.web.config;//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.admin.web.strategy.FirstLoginChangePasswordStrategy;
import com.biz.crm.mdm.admin.web.strategy.PasswordOverdueStrategy;
import com.bizunited.nebula.common.configuration.SimpleTenantProperties;
import com.bizunited.nebula.common.controller.model.ResponseCode;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.security.local.notifier.TenantRequestEventListenerForSecurity;
import com.bizunited.nebula.security.local.utils.HandleOutPut;
import com.bizunited.nebula.security.local.utils.JwtUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.event.AuthenticatedEventListener;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.transaction.Transactional;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/**
 * 密码过期修改需求的临时处理方案
 * 后续登录数据可扩展时进行二次处理
 *
 * @author jerry7
 */
@Component("nebulaSecurityAuthenticationSuccessHandler")
public class MdmSecurityAuthenticationSuccessHandler extends SavedRequestAwareAuthenticationSuccessHandler implements HandleOutPut {
  @Autowired(required = false)
  private List<AuthenticatedEventListener> authenticatedEventListeners;
  @Autowired(required = false)
  private List<PasswordOverdueStrategy> passwordOverdueStrategies;

  @Autowired(required = false)
  private List<FirstLoginChangePasswordStrategy> firstLoginChangePasswordStrategies;
  @Autowired
  private SimpleSecurityProperties simpleSecurityProperties;
  @Autowired
  private SimpleTenantProperties simpleTenantProperties;

  /**
   * 密码过期验证策略
   */
  @Value("${password.overdue.overdueStrategy:notAllowLogin}")
  private String overdueStrategy;
  private static final Logger LOGGER = LoggerFactory.getLogger(TenantRequestEventListenerForSecurity.class);

  public MdmSecurityAuthenticationSuccessHandler() {
  }

  @Transactional
  public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
    UserIdentity userIdentity = (UserIdentity) authentication.getDetails();
    String tenantCode = userIdentity.getTenantCode();
    if (StringUtils.isBlank(tenantCode)) {
      tenantCode = this.findTenantCodeFromServletRequest(request);

      try {
        Field field = UserIdentity.class.getDeclaredField("tenantCode");
        field.setAccessible(true);
        field.set(userIdentity, tenantCode);
      } catch (SecurityException | IllegalAccessException | NoSuchFieldException var13) {
        LOGGER.warn(var13.getMessage());
      }
    }

    if (!CollectionUtils.isEmpty(this.authenticatedEventListeners)) {
      Iterator var14 = this.authenticatedEventListeners.iterator();
      while (var14.hasNext()) {
        AuthenticatedEventListener authenticatedEventListener = (AuthenticatedEventListener) var14.next();
        authenticatedEventListener.onAuthenticationSuccess(userIdentity, authentication);
      }
    }

    Collection<String> setCookies = response.getHeaders("Set-Cookie");
    String jsession = null;
    if (setCookies != null) {
      Iterator var8 = setCookies.iterator();

      while (var8.hasNext()) {
        String setCookie = (String) var8.next();
        int indexd;
        String value;
        if (StringUtils.indexOf(setCookie, "persistence=") != -1) {
          indexd = setCookie.indexOf(61);
          value = setCookie.substring(indexd + 1);
          response.setHeader("persistence", value);
        } else if (StringUtils.indexOf(setCookie, "JSESSIONID=") != -1) {
          indexd = setCookie.indexOf(61);
          value = setCookie.substring(indexd + 1);
          jsession = value;
        }
      }

      response.setHeader("Access-Control-Expose-Headers", "JSESSIONID,persistence,Cookie");
    }

    if (StringUtils.isBlank(jsession)) {
      HttpSession session = request.getSession();
      jsession = session.getId();
      Cookie cookie = new Cookie("JSESSIONID", jsession);
      cookie.setSecure(true);
      response.addCookie(cookie);
      session.setAttribute("tenantCode", tenantCode);
    }

    response.setHeader("JSESSIONID", jsession);
    ResponseModel result = new ResponseModel(System.currentTimeMillis(), (Object) null, ResponseCode.E0, (Throwable) null);
    JSONObject resultJson = new JSONObject();
    String[] roles = null;
    Collection<? extends GrantedAuthority> authoritys = authentication.getAuthorities();
    if (!CollectionUtils.isEmpty(authoritys)) {
      roles = (String[]) authoritys.stream().map(GrantedAuthority::getAuthority).toArray((x$0) -> {
        return new String[x$0];
      });
    }
    String jwtEncodeContent = JwtUtils.encode(userIdentity, 0, this.simpleSecurityProperties.getSecretKey());
    resultJson.put("account", userIdentity.getAccount());
    resultJson.put("identityType", userIdentity.getIdentityType());
    resultJson.put("tenantCode", tenantCode);
    resultJson.put("roles", roles);
    resultJson.put("jwt", jwtEncodeContent);
    //校验密码过期策略
    try {
      PasswordOverdueStrategy strategy = this.getPasswordOverdueStrategy();
      if (ObjectUtils.isNotEmpty(strategy)) {
        strategy.handle(userIdentity.getAccount(), resultJson);
      }
    }catch (Exception e){
      ResponseModel model = new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E603, new IllegalAccessException(e.getMessage()));
      response.setContentType("application/json;charset=UTF-8");
      response.getWriter().write(JsonUtils.obj2JsonString(model));
      return;
    }

    //校验首次登陆强制修改密码策略
    if (!CollectionUtils.isEmpty(firstLoginChangePasswordStrategies)) {
      for (FirstLoginChangePasswordStrategy firstLoginStrategy : firstLoginChangePasswordStrategies) {
        firstLoginStrategy.handle(userIdentity, resultJson);
      }
    }
    result.setData(resultJson);
    this.writeResponse(response, result);
  }

  private String decodeBase64(String data) {
    return new String(Base64.getDecoder().decode(data), StandardCharsets.UTF_8);
  }

  private String findTenantCodeFromServletRequest(HttpServletRequest request) {
    try {
      String securityData = request.getHeader(this.simpleTenantProperties.getHeadAppKey());
      if (StringUtils.isAnyBlank(new CharSequence[]{securityData})) {
        return this.simpleTenantProperties.getUseDefaultTenantCode() ? this.simpleTenantProperties.getDefaultTenantCode() : null;
      } else {
        JSONObject jsonData = JSON.parseObject(this.decodeBase64(securityData));
        Validate.notNull(jsonData, "网关信息解密错误，请检查！", new Object[0]);
        String tenantCode = jsonData.getString("tenantCode");
        Validate.notBlank(tenantCode, "网关信息不全，请检查！", new Object[0]);
        LOGGER.debug("当前请求携带的租户信息为:{}", tenantCode);
        return tenantCode;
      }
    } catch (RuntimeException var5) {
      LOGGER.error(var5.getMessage(), var5);
      return this.simpleTenantProperties.getUseDefaultTenantCode() ? this.simpleTenantProperties.getDefaultTenantCode() : null;
    }
  }

  /**
   * 获取密码控制策略
   *
   * @return 指定的密码控制策略
   */
  private PasswordOverdueStrategy getPasswordOverdueStrategy() {
    if (CollectionUtils.isEmpty(passwordOverdueStrategies)||StringUtils.isBlank(overdueStrategy)) {
      return null;
    }
    for (PasswordOverdueStrategy strategy : passwordOverdueStrategies) {
      if (strategy.name().equals(overdueStrategy)) {
        return strategy;
      }
    }
    return null;
  }
}
