package com.biz.crm.mdm.admin.web.dataview.customer;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author jerry7
 * mdm客户用户数据视图
 */
@Component
public class CustomerMaterialDataviewRegister implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_customerMaterial_dataview";
  }

  @Override
  public String desc() {
    return "MDM客户物料数据视图";
  }

  @Override
  public String buildSql() {
    return "SELECT " +
            "        cm.id as id, " +
            "        cm.customer_org_code as customerOrgCode , " +
            "        cm.material_code as materialCode , " +
            "        cm.bar_code as barCode , " +
            "        cm.tenant_code as tenantCode, " +
            "        cm.del_flag as delFlag, " +
            "        cm.enable_status as enableStatus, " +
            "        cm.create_account as createAccount, " +
            "        cm.create_time as create_time, " +
            "        cm.create_name as createName, " +
            "        cm.modify_account as modifyAccount, " +
            "        cm.modify_time as modifyTime, " +
            "        cm.modify_name as modifyName, " +
            "        cm.remark as remark, " +
            "        material.material_name as materialName , " +
            "        org.customer_org_name as customerOrgName " +
            "    FROM mdm_customer_material cm " +
            "    LEFT JOIN mdm_material material on cm.material_code = material.material_code " +
            "    LEFT JOIN mdm_customer_org org on cm.customer_org_code = org.customer_org_code " +
            "    where cm.del_flag = '009' " ;
  }
}
