package com.biz.crm.mdm.admin.web.dataview.customer.strategy;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrg;
import com.biz.crm.mdm.business.customer.org.local.repository.CustomerOrgRepository;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author hejun
 * @title CustomerOrgParameterValueBindingStrategy
 * @date 2022/12/29 17:29
 * @description 客户组织ruleCode规则编码取值
 */
@Component("CustomerOrgParameterValueBindingStrategy")
public class CustomerOrgParameterValueBindingStrategy implements ParameterValueBindingStrategy {
  @Autowired
  private CustomerOrgRepository customerOrgRepository;

  @Override
  public String getBindType() {
    return "CustomerOrg_RuleCode";
  }

  @Override
  public String getBindTypeCnName() {
    return "客户组织ruleCode规则编码取值";
  }

  @Override
  public Boolean getOutside() {
    return false;
  }

  @Override
  public Class<?>[] matchedJavaClasses() {
    return new Class[]{CharSequence.class};
  }

  @Override
  public Object bindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
   String customerOrgCode = (String) databaseExecuteExternalRequest.getAttribute("underCustomerOrgCode");
    if (StringUtils.isBlank(customerOrgCode)) {
      return null;
    }
    String ruleCodeByCustomerOrgCode = customerOrgRepository.findRuleCodeByCustomerOrgCode(customerOrgCode);
    if (StringUtils.isBlank(ruleCodeByCustomerOrgCode)){
      return null;
    }
    return ruleCodeByCustomerOrgCode;
  }
}
