package com.biz.crm.mdm.admin.web.dataview.general;

import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @author jerry7
 * @describe: （通用）获取企业组织orgCode规则编码
 */
@Component("GeneralOrgCodeParameterValueBindingStrategy")
public class GeneralOrgCodeParameterValueBindingStrategy implements ParameterValueBindingStrategy {


  public GeneralOrgCodeParameterValueBindingStrategy() {
  }

  @Override
  public String getBindType() {
    return "General_OrgCode";
  }

  @Override
  public String getBindTypeCnName() {
    return "（通用）获取企业组织orgCode";
  }

  @Override
  public Boolean getOutside() {
    return false;
  }

  @Override
  public Class<?>[] matchedJavaClasses() {
    return new Class[]{CharSequence.class};
  }

  @Override
  public Object bindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
    String orgCode = (String) databaseExecuteExternalRequest.getAttribute("allUnderOrgCode");
    if (StringUtils.isBlank(orgCode)){
      return null;
    }
    return orgCode;
  }
}
