package com.biz.crm.mdm.admin.web.dataview.org.interceptor;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;

import com.bizunited.nebula.mars.local.entity.MarsAuthorityDetailEntity;
import com.bizunited.nebula.mars.local.entity.MarsAuthorityEntity;
import com.bizunited.nebula.mars.local.vo.MarsAuthorityQueryVo;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;

import com.google.common.collect.Lists;
import jodd.util.ArraysUtil;
import liquibase.pro.packaged.S;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;


import javax.persistence.EntityManager;
import java.util.*;

/**
 * @author hejun
 * @title MarsAuthorityQueryInterceptor
 * @date 2023/1/3 11:58
 * @description 数据权限数据视图参数补充
 */
@Component
public class MarsAuthorityQueryInterceptor implements ExternalQueryInterceptor {
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  @Lazy
  private Set<SelectScopeRegister> selectScopeRegisters;

  @Autowired(
      required = false
  )
  @Lazy
  private Set<SelectAuthorityModeRegister> selectAuthorityModeRegisters;

  @Override
  public String code() {
    return "mdm_mars_auth_query_interceptor";
  }

  @Override
  public String name() {
    return "MDM数据权限数据视图参数补充";
  }

  @Override
  public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo, ExecuteContent executeContent, String... strings) {
    List<Map<String, Object>> results = executeContent.getResults();
    if(CollectionUtils.isEmpty(results)){
      return null;
    }
    if (0 == results.parallelStream().filter(row -> row != null).count()) {
      return org.apache.commons.compress.utils.Lists.newArrayList();
    }
    List<MarsAuthorityEntity> marsAuthorityList = Lists.newArrayList();
    List<MarsAuthorityQueryVo>marsAuthorityQueryVos=Lists.newArrayList();
    results.forEach(result -> {
      MarsAuthorityQueryVo marsAuthorityQueryVo = new MarsAuthorityQueryVo();
      MarsAuthorityEntity marsAuthorityEntity = new MarsAuthorityEntity();
      marsAuthorityQueryVo.setScopeKey((String) result.get("scope_key"));
      //marsAuthorityQueryVo.setSelectModeKeys((String[]) result.get("select_mode_key"));
      marsAuthorityQueryVo.setSelectModeKeys( new String [] {(String) result.get("select_mode_key")});
      BeanUtils.copyProperties(marsAuthorityQueryVo, marsAuthorityEntity);
      marsAuthorityList.add(marsAuthorityEntity);
     /* //参数验证 和额外字段补充验证
      List<MarsAuthorityQueryVo> marsAuthorityQueryVoList = this.validate(marsAuthorityList);
      //整合数据
      marsAuthorityQueryVos.addAll(marsAuthorityQueryVoList);*/
      marsAuthorityQueryVos.add(marsAuthorityQueryVo);
    });
    this.validate(marsAuthorityQueryVos);

    List<Object[]> externalContents = Lists.newArrayList();
    marsAuthorityQueryVos.stream().forEach(marsAuthorityQueryVo -> {
      results.stream().forEach(result->{
      List<Object>itemList = Lists.newArrayList();
      for (String externalFileName : strings){
        if (StringUtils.equals(externalFileName,"scopeName")) {
          if (StringUtils.isNotEmpty(marsAuthorityQueryVo.getScopeName())){
            itemList.add(marsAuthorityQueryVo.getScopeName());
          }else{
            itemList.add("");
          }
      }
        if (StringUtils.equals(externalFileName,"selectModeNames")){
          if (!ObjectUtils.isEmpty(marsAuthorityQueryVo.getSelectModeNames())){
            itemList.add(marsAuthorityQueryVo.getSelectModeNames());
          }else{
            itemList.add("");
          }
        }
      }
      externalContents.add(itemList.toArray(new Object[]{}));
      });
    });
    return externalContents;
  }

  /**
   * 数据处理
   * @param marsAuthorityList
   * @return
   */
  private List<MarsAuthorityQueryVo> validate(List<MarsAuthorityQueryVo> marsAuthorityList) {
    if (marsAuthorityList != null && !marsAuthorityList.isEmpty()) {
      //Collection<MarsAuthorityQueryVo> marsAuthorityQuerys = this.nebulaToolkitService.copyCollectionByWhiteList(marsAuthorityList, MarsAuthorityEntity.class, MarsAuthorityQueryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
      Iterator var5 = marsAuthorityList.iterator();

      while (true) {
        MarsAuthorityQueryVo marsAuthorityQueryVo;
        String[] selectModeKeys;
        do {
          do {
            if (!var5.hasNext()) {
              /*return Lists.newArrayList(marsAuthorityQuerys);*/
              return Lists.newArrayList(marsAuthorityList);
            }
            marsAuthorityQueryVo = (MarsAuthorityQueryVo) var5.next();
            String scopeKey = marsAuthorityQueryVo.getScopeKey();
            selectModeKeys = marsAuthorityQueryVo.getSelectModeKeys();
            if (StringUtils.isNotBlank(scopeKey) && !CollectionUtils.isEmpty(this.selectScopeRegisters)) {
              Iterator var9 = this.selectScopeRegisters.iterator();

              while (var9.hasNext()) {
                SelectScopeRegister selectScopeRegister = (SelectScopeRegister) var9.next();
                if (StringUtils.equals(selectScopeRegister.scopeKey(), scopeKey)) {
                  marsAuthorityQueryVo.setScopeName(selectScopeRegister.selectName());
                }
              }
            }
          } while (selectModeKeys == null);
        } while (CollectionUtils.isEmpty(this.selectAuthorityModeRegisters));

        List<String> selectModeNames = Lists.newArrayList();
        Iterator var13 = this.selectAuthorityModeRegisters.iterator();

        while (var13.hasNext()) {
          SelectAuthorityModeRegister selectAuthorityModeRegister = (SelectAuthorityModeRegister) var13.next();
          if (StringUtils.equalsAny(selectAuthorityModeRegister.modeKey(), selectModeKeys)) {
            selectModeNames.add(selectAuthorityModeRegister.modeName());
          }
        }
        marsAuthorityQueryVo.setSelectModeNames((String[]) selectModeNames.toArray(new String[0]));
      }
    } else {
      return null;
    }
  }

}
