package com.biz.crm.mdm.admin.web.dataview.product;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author jerry7
 * mdm产品管理数据视图
 */
@Component
public class ProductDataviewRegister implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_product_dataview";
  }

  @Override
  public String desc() {
    return "MDM产品管理数据视图";
  }

  @Override
  public String buildSql() {
    return "select a.id,  " +
            "    a.product_code,  " +
            "    a.product_name,  " +
            "    a.product_level_code,  " +
            "    b.product_level_name,  " +
            "    a.product_type,  " +
            "    b.rule_code,    " +
            "    a.sale_unit,  " +
            "    a.sale_company,  " +
            "    a.spec,  " +
            "    a.base_unit,  " +
            "    a.is_shelf,  " +
            "    a.enable_status,  " +
            "    a.bar_code,  " +
            "    a.maintenance_picture,  " +
            "    a.maintenance_introduction,  " +
            "    a.PIC_URL,  " +
            "    a.PRIMARY_PICTURE_URL,  " +
            "    a.begin_date_time,  " +
            "    a.tenant_code,  " +
            "    a.end_date_time  " +
            "    from mdm_product a  " +
            "    left join mdm_product_level b on a.tenant_code=b.tenant_code and a.product_level_code = b.product_level_code " +
            "    where a.del_flag = '009' and  a.product_level_code = :product_level_code "+
            "    and a.tenant_code = :tenantCode " ;
  }
}
