package com.biz.crm.mdm.admin.web.dataview.product;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.biz.crm.mdm.business.product.level.local.repository.ProductLevelRepository;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author hejun
 * @title ProductLevelRuleCodeParameterValueBindingStrategy
 * @date 2023/2/1 10:39
 * @description 产品层级ruleCode规则编码取值
 */
@Component
public class ProductLevelRuleCodeParameterValueBindingStrategy implements ParameterValueBindingStrategy {

  @Autowired
  private ProductLevelRepository productLevelRepository;

  @Override
  public String getBindType() {
    return "ProductLevel_RuleCode";
  }

  @Override
  public String getBindTypeCnName() {
    return "产品层级ruleCode规则编码取值";
  }

  @Override
  public Boolean getOutside() {
    return false;
  }

  @Override
  public Class<?>[] matchedJavaClasses() {
    return new Class[]{CharSequence.class};
  }

  @Override
  public Object bindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
    String productLevelCode = (String) databaseExecuteExternalRequest.getAttribute("underProductLevelCode");
    if (StringUtils.isEmpty(productLevelCode)){
      return null;
    }
    String ruleCode = productLevelRepository.findRuleCodeByProductLevelCode(productLevelCode);
    if (StringUtils.isEmpty(ruleCode)) {
        return null;
    }
    return ruleCode;
  }
}
