package com.biz.crm.mdm.admin.web.dataview.product;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author jerry7
 * mdm仓库管理数据视图
 */
@Component
public class WareHouseDataviewRegister implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_wareHouse_dataview";
  }

  @Override
  public String desc() {
    return "MDM仓库管理数据视图";
  }

  @Override
  public String buildSql() {
    return  
        " select  " +
        "  a.* ,  " +
        "  max(c.region_name) as province_name,  " +
        "  max(d.region_name) as city_name  " +
        " from  " +
        "  mdm_warehouse a  " +
        " LEFT JOIN mdm_region c ON a.province_code = c.region_code  " +
        " LEFT JOIN mdm_region d ON a.city_code = d.region_code  "  +
        " where  " +
        "  a.del_flag = '009'  " +
        "  and a.tenant_code = :tenantCode  " +
        " group by  " +
        "  a.id";
  }
}
