package com.biz.crm.mdm.admin.web.dataview.productspu;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUserRelaCustomer;
import com.biz.crm.mdm.business.customer.user.local.service.CustomerUserRelaCustomerService;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTag;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuTagMapping;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuTagMappingRepository;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuTagMappingQueryDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author jerry7
 * mdm商品标签数据视图补充
 */
@Component
public class ProductSpuTagQueryInterceptor implements ExternalQueryInterceptor {

  @Autowired
  private ProductSpuTagMappingRepository productSpuTagMappingRepository;
  private static final String TAG_CODE = "tag_code";

  @Override
  public String code() {
    return "mdm_productSpuTag_queryInterceptor";
  }

  @Override
  public String name() {
    return "mdm商品标签管理-商品展示数量";
  }

  @Override
  public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo, ExecuteContent executeContent, String... strings) {
    List<Map<String, Object>> resutls = executeContent.getResults();
    if (CollectionUtils.isEmpty(resutls)) {
      return null;
    }
    if (0 == resutls.parallelStream().filter(row -> row != null).count()) {
      return Lists.newLinkedList();
    }
    Set<String> tagCodeSet = Sets.newHashSet();
    resutls.forEach(map -> {
      if (map.containsKey(TAG_CODE)) {
        tagCodeSet.add((String) map.get(TAG_CODE));
      }
    });
    if (CollectionUtils.isEmpty(tagCodeSet)) {
      return null;
    }
    ProductSpuTagMappingQueryDto queryDto = new ProductSpuTagMappingQueryDto();
    queryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    queryDto.setTenantCode(TenantUtils.getTenantCode());
    queryDto.setTagCodes(tagCodeSet);
    List<ProductSpuTagMapping> list =
            this.productSpuTagMappingRepository.findByProductSpuTagMappingQueryDto(queryDto);
    final Map<String, Long> map = list.stream().collect(Collectors.groupingBy(ProductSpuTagMapping::getTagCode, Collectors.counting()));
    // 组装商品信息
    List<Object[]> externalContents = Lists.newArrayList();
    for (int index = 0; index < resutls.size(); index++) {
      List<Object> itemList = Lists.newArrayList();
      String tagCode = (String) resutls.get(index).get(TAG_CODE);
      if (StringUtils.isBlank(tagCode)) {
        continue;
      }
      itemList.add(map.getOrDefault(tagCode, 0L));
      externalContents.add(itemList.toArray(new Object[]{}));
    }
    return externalContents;
  }
}
