package com.biz.crm.mdm.admin.web.dataview.terminal;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe:MDM终端信息数据视图
 * @createTime 2022年09月13日 16:37:00
 */
@Component
public class TerminalDataviewRegister implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_terminal_dataview";
  }

  @Override
  public String desc() {
    return "MDM终端信息数据视图";
  }

  @Override
  public String buildSql() {
    return "select  a.ID,\n" +
        "        a.terminal_code as terminalCode,\n" +
        "        a.del_flag,\n" +
        "        a.enable_status,\n" +
        "        a.terminal_name,\n" +
        "        a.terminal_type,\n" +
        "        b.org_code,\n" +
            "        c.org_name,\n" +
        "        a.customer_org_code,\n" +
        "        a.channel,\n" +
        "        a.license_person_name,\n" +
        "        a.license_register_number,\n" +
        "        a.license_firm_name,\n" +
        "        a.province_code,\n" +
        "        a.city_code,\n" +
        "        a.district_code,\n" +
        "        a.shop_image_path,\n" +
        "        a.license_image_path,\n" +
        "        a.create_org_name,\n" +
        "        a.enable_status_name,\n" +
        "        a.terminal_address,\n" +
        "        a.remarks,\n" +
        "        a.longitude,\n" +
        "        a.latitude,\n" +
        "        a.customer_classification,\n" +
        "        a.act_approve_status,\n" +
        "        a.cooperate_status,\n" +
        "        a.store_id,\n" +
        "        a.direct_system_id,\n" +
        "        a.sell_party_id,\n" +
        "        a.amap_id,\n" +
        "        a.approval_type,\n" +
        "        a.process_code,\n" +
        "        a.PROVINCE_NAME,\n" +
        "        a.CITY_NAME,\n" +
        "        a.DISTRICT_NAME,\n" +
        "        a.UPDATE_DATE_ALL,\n" +
        "        a.CREATE_DATE_ALL,\n" +
        "        a.SOURCE_TYPE,\n" +
        "        a.create_account,\n" +
        "        a.create_time,\n" +
        "        a.modify_account,\n" +
        "        a.modify_name,\n" +
        "        a.modify_time,\n" +
        "        a.remark,\n" +
        "        a.tenant_code,\n" +
        "        a.process_key,\n" +
        "        a.process_number,\n" +
        "        a.process_remark,\n" +
        "        a.process_status\n" +
        "    from mdm_terminal a FORCE INDEX(mdm_terminal_force_index4)\n" +
        "    left join mdm_terminal_r_org b\n" +
        "    on a.tenant_code = b.tenant_code and a.terminal_code = b.terminal_code\n" +
        "    left join mdm_org c on c.tenant_code = b.tenant_code and b.org_code = c.org_code\n" +
        "    where a.del_flag='009' and a.tenant_code= :tenantCode and c.rule_code like concat(:ruleCode,'%')" ;
  }

}
