package com.biz.crm.mdm.admin.web.exports.customer.service;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.admin.web.exports.customer.mapper.CustomerExportsMapper;
import com.biz.crm.mdm.admin.web.exports.customer.model.CustomerCrmExportVo;
import com.biz.crm.mdm.admin.web.exports.customer.model.CustomerExportDto;
import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrg;
import com.biz.crm.mdm.business.customer.org.local.service.CustomerOrgVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.transaction.Transactional;

/**
 * @author HanJiaJun
 * @describe: 客户信息导出
 * @createTime 2022年05月23日 21:16:00
 */
@Component
public class CustomerExportProcess implements ExportProcess<CustomerCrmExportVo> {
  @Autowired(required = false)
  private CustomerExportsMapper customerMapper;
  @Autowired(required = false)
  private OrgService orgService;
  @Autowired(required = false)
  private CustomerOrgVoService customerOrgVoService;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;
  @Autowired(required = false)
  private RegionVoService regionVoService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    CustomerExportDto dto = this.findTestDataDto(params);
    return customerMapper.getExportTotal(dto);
  }

  @Override
  @Transactional /* 必须加上事务，否则导出的数据视图将会失效 */
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    final CustomerExportDto dto = this.findTestDataDto(params);
    dto.setOffset(this.getPageSize() * vo.getPageNo());
    dto.setLimit(vo.getPageSize());
    final List<CustomerCrmExportVo> data = this.customerMapper.findData(dto);
    //调整数据
    adjustData(data);
    return toJSONArray(data);
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private void adjustData(List<CustomerCrmExportVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return;
    }
    Map<String, String> orgMap = new HashMap<>();
    Map<String, String> customerOrgMap = new HashMap<>();
    Map<String, String> channleMap = new HashMap<>();
    Map<String, String> typeMap =new HashMap<>();
    //查询组织
    List<String> orgCodes = data.stream().filter(e -> StringUtils.isNotBlank(e.getOrgCode())).map(CustomerCrmExportVo::getOrgCode).collect(Collectors.toList());
    List<Org> byOrgCodes = orgService.findByOrgCodes(orgCodes);
    if (CollectionUtils.isNotEmpty(byOrgCodes)) {
      orgMap = byOrgCodes.stream().collect(Collectors.toMap(Org::getOrgCode, Org::getOrgName, (k1, k2) -> k1));
    }
    //查询客户组织
    List<String> customerOrgCodes = data.stream().filter(e -> StringUtils.isNotBlank(e.getCustomerCode())).map(CustomerCrmExportVo::getCustomerOrgCode).collect(Collectors.toList());
    List<CustomerOrg> byCustomerOrgCodes = this.customerOrgVoService.findByCustomerOrgCodes(customerOrgCodes);
    if (CollectionUtils.isNotEmpty(byCustomerOrgCodes)) {
      customerOrgMap = byCustomerOrgCodes.stream().collect(Collectors.toMap(CustomerOrg::getCustomerOrgCode, CustomerOrg::getCustomerOrgName, (k1, k2) -> k1));
    }
    //查询渠道
    List<DictDataVo> byDictTypeCode = this.dictDataVoService.findByDictTypeCode(PriceDimensionEnum.CHANNEL.getDictCode());
    if (CollectionUtils.isNotEmpty(byDictTypeCode)) {
      channleMap = byDictTypeCode.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
    }
    //查询省市区
    List<String> regionCodes =new ArrayList<>();
    for (CustomerCrmExportVo vo : data) {
      regionCodes.add(vo.getCityCode());
      regionCodes.add(vo.getProvinceCode());
      regionCodes.add(vo.getDistrictCode());
    }
    Map<String, String> regionCodeNameMap = this.regionVoService.findRegionCodeNameMap(regionCodes);
    //查询客户类型
    List<DictDataVo> customerType = this.dictDataVoService.findByDictTypeCode("customer_type");
    if (CollectionUtils.isNotEmpty(customerType)){
       typeMap = customerType.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
    }
    //补充数据
    for (CustomerCrmExportVo vo : data) {
      String orgName = orgMap.get(vo.getOrgCode());
      if (StringUtils.isNotBlank(orgName)){
        vo.setOrgName(orgName);
      }
      String customerOrgName = customerOrgMap.get(vo.getCustomerOrgCode());
      if (StringUtils.isNotBlank(customerOrgName)){
        vo.setCustomerOrgName(customerOrgName);
      }
      String channelName = channleMap.get(vo.getChannel());
      if (StringUtils.isNotBlank(channelName)){
        vo.setChannelName(channelName);
      }
      //省市区
      String provinceName = regionCodeNameMap.get(vo.getProvinceCode());
      String cityName = regionCodeNameMap.get(vo.getCityCode());
      String districtName = regionCodeNameMap.get(vo.getDistrictCode());
      if (StringUtils.isNotBlank(provinceName)){
        vo.setProvinceName(provinceName);
      }
      if (StringUtils.isNotBlank(cityName)){
        vo.setCityName(cityName);
      }
      if (StringUtils.isNotBlank(districtName)){
        vo.setDistrictName(districtName);
      }
      //
      String typeName = typeMap.get(vo.getCustomerType());
      if (StringUtils.isNotBlank(typeName)){
        vo.setCustomerTypeName(typeName);
      }
      EnableStatusEnum enableStatusEnum = EnableStatusEnum.codeToEnum(vo.getEnableStatus());
      vo.setEnableStatusName(enableStatusEnum.getDes());
      String statusName = ProcessStatusEnum.getStatusNameByKey(vo.getProcessStatus());
      vo.setProcessStatusName(statusName);
    }
  }
  
  @Override
  public Class<CustomerCrmExportVo> findCrmExcelVoClass() {
    return CustomerCrmExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "MDM_CUSTOMER_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "MDM客户信息导出";
  }


  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private CustomerExportDto findTestDataDto(Map<String, Object> params) {
    final CustomerExportDto dto = new CustomerExportDto();
    final Object customerCode = params.get("customerCode");
    final Object customerName = params.get("customerName");
    final Object customerType = params.get("customerType");
    final Object processStatus = params.get("processStatus");
    final Object lockState = params.get("lockState");
    final Object enableStatus = params.get("enableStatus");
    if (Objects.nonNull(customerCode)) {
      dto.setCustomerCode(customerCode.toString());
    }
    if (Objects.nonNull(customerName)) {
      dto.setCustomerName(customerName.toString());
    }
    if (Objects.nonNull(customerType)) {
      dto.setCustomerType(customerType.toString());
    }
    if (Objects.nonNull(processStatus)) {
      dto.setProcessStatus(processStatus.toString());
    }
    if (Objects.nonNull(lockState)) {
      dto.setLockState(lockState.toString());
    }
    if (Objects.nonNull(enableStatus)) {
      dto.setEnableStatus(enableStatus.toString());
    }
    return dto;
  }
}
