package com.biz.crm.mdm.admin.web.exports.dataview.stratagy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.biz.crm.common.ie.sdk.excel.strategy.CrmExportColumnStrategy;
import com.biz.crm.common.ie.sdk.excel.vo.ColumnVo;
import com.biz.crm.common.ie.sdk.excel.vo.FunctionPermissionVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigPersonalVoService;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigPersonalVo;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigVo;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityExcludedFieldDetailService;
import com.google.common.collect.Lists;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.json.JSONObject;

/**
 * 描述：</br>
 * mdm中通过个性化设置以及页面引擎中的导出配置信息过滤导出的数据字段
 *
 * @author keller
 * @date 2022/10/12
 * @version 2023-01-03 修正数据字典查询bug {@link #fullDictCode(List, List)}
 */
@Component
public class EuropaCrmExportColumnStrategy implements CrmExportColumnStrategy {
  @Autowired
  private ColumnConfigPersonalVoService           columnConfigPersonalVoService;
  @Autowired
  private ColumnConfigVoService                   columnConfigVoService;
  @Autowired
  private DictDataVoService                       dictDataVoService;
//  @Qualifier("marsAuthorityExcludedFieldDetailServiceRemote")
  @Autowired
  private MarsAuthorityExcludedFieldDetailService marsAuthorityExcludedFieldDetailService;
  
  @Override
  public Set<String> exportColumn(ExportTaskProcessVo vo) {
    String parentCode = vo.getParentCode();
    String functionCode = vo.getFunctionCode();
    List<ColumnVo> showDataviewColumn = getShowDataviewColumn(parentCode, functionCode);
    Set<String> collect = showDataviewColumn.parallelStream().map(ColumnVo::getField).collect(Collectors.toSet());
    return collect;
  }
  
  @Override
  public List<ColumnVo> getShowDataviewColumn(FunctionPermissionVo funPermVo) {
    return this.getShowDataviewColumn(funPermVo.getParentCode(), funPermVo.getFunctionCode());
  }
  
  /**
   * 获取显示的数据视图字段
   * 
   * @param parentCode
   * @param functionCode
   * @return 可以显示，并可以导出的字段
   */
  @Override
  public List<ColumnVo> getShowDataviewColumn(String parentCode, String functionCode) {
    if (StringUtils.isAnyBlank(parentCode, functionCode)) {
      return Collections.emptyList();
    }
    // 页面引擎配置
    List<ColumnConfigVo> columnConfigVos =
        this.columnConfigVoService.findByParentCodeAndFunctionCodeOrderByFormorder(parentCode, functionCode);
    if (columnConfigVos == null) {
      return Collections.emptyList();
    }
    // 查出所有可导出的字段
    Map<String, ColumnVo> columnConfigVosMap = columnConfigVos.parallelStream()
        // 过滤显示并且可以导出的字段
        .filter(item -> (
//            item.getVisible() && // 只保留可见
            "1".equals(item.getColumnExport()))) // 只保留允许导出的
        .map(row -> {
          ColumnVo vo = new ColumnVo();
          String dictTypeCode = row.getDictCode();
          vo.setDictTypeCode(dictTypeCode);
          vo.setField(row.getField());
          vo.setTitle(row.getTitle());
//          vo.setColumnExport("1".equals(row.getColumnExport()));
          return vo;
        })
        .collect(Collectors.toMap(ColumnVo::getField, row -> {
          return row;
        }));
    
    // // 检查个性化设置
    List<ColumnConfigPersonalVo> columnConfigPersonalVos =
        this.columnConfigPersonalVoService.findByParentCodeAndFunctionCode(parentCode, functionCode);
    // 数据权限过滤
    MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
    String listCode = marsAuthorityContext.getListCode();
    Set<String> fileds = this.marsAuthorityExcludedFieldDetailService.findByListCode(listCode);
    
    List<ColumnConfigPersonalVo> collect = columnConfigPersonalVos.parallelStream()
        .filter(ColumnConfigPersonalVo::getVisible)
        .filter(row -> {
          if (fileds == null) {
            return true;
          } else {
            String field = row.getField();
            return fileds.contains(field);
          }
        })
        .collect(Collectors.toList());
    
    List<ColumnVo> innerColumnCfg = collect.parallelStream()
        .filter(row -> {
          String field = row.getField();
          return columnConfigVosMap.containsKey(field);
        })
        .map(row -> {
          String field = row.getField();
          return columnConfigVosMap.get(field);
        })
        .collect(Collectors.toList());
    return innerColumnCfg;
  }
  
  @Override
  public List<JSONObject> fullDictCode(List<JSONObject> excelDataList,
      List<ColumnVo> showDataviewColumn) {
    // 数据字典Map对象
    Map<String, Map<String, String>> allDictCodeMap = getColumnDictCodeMap(showDataviewColumn);
    // 遍历查询的数据，跟进要显示的字段进行组装数据
    List<JSONObject> result = Lists.newLinkedList();
    for (JSONObject rowData : excelDataList) {
      // {"del_flag":"009","modify_name":"超级管理员","create_time":1668514716000,"position_code":"ZW00000086","level_num":1,"user_name":"13984415133","modify_account":"admin","modify_time":1668514992000,"position_name":"职位-纳美大区销售总监","role_code":"JS01","create_account":"admin","enable_status":"009","full_name":"徐清01-纳美大区销售总监","rule_code":"000169","position_level_name":"纳美大区销售总监","parent_code":"","primary_flag":"1","position_level_code":"ZWJB001","id":"86fc0187795b50fc7fd3f0bc39e3fbbe","org_name":"市场部","org_code":"ZZ00101","create_name":"超级管理员","tenant_code":"default"}
      JSONObject jsonObj = new JSONObject();
      jsonObj.putAll(rowData);
      // 获取当前字段名称
      for (String dictTypeCode : allDictCodeMap.keySet()) {
        // 获取当前字段对应的字典值
        Object dictType = jsonObj.get(dictTypeCode);
        String dictTypeStr = "" + dictType;
        Map<String, String> map = allDictCodeMap.get(dictTypeCode);
        String dictValue = map.get(dictTypeStr);
        if (dictValue == null) {
          // 兼容前台对字典表的boolean的兼容模式
          Boolean dictValueForDb = BooleanUtil.toBooleanObject(dictTypeStr);
          if (dictValueForDb != null) {
            // 可能存在字典表写各种各样true和false的形式
            for (String key : map.keySet()) {
              Boolean dictValueForDic = BooleanUtil.toBooleanObject(key);
              if (dictValueForDb == dictValueForDic) {
                dictValue = map.get(key);
                map.put(dictTypeStr, dictValue);
                map.remove(key);
                break;
              }
            }
          }
        }
        if (dictValue != null) {
          // 替换字典
          jsonObj.set(dictTypeCode, dictValue);
        }
      }
      result.add(jsonObj);
    }
    return result;
  }
  
  private Map<String, Map<String, String>> getColumnDictCodeMap(List<ColumnVo> showDataviewColumn) {
    Map<String, Map<String, String>> allDictCodeMap = new HashMap<>();
    // XZK 根据请求的数据，获取本次调用所需数据字典
    Map<String,String> dictType2FiledCodeMap  = new HashMap<>(showDataviewColumn.size());
    for (ColumnVo columnVo : showDataviewColumn) {
      String dictTypeCode = columnVo.getDictTypeCode();
      if (StringUtils.isBlank(dictTypeCode)) {
        continue;
      }
      dictType2FiledCodeMap.put(dictTypeCode, columnVo.getField());
    }
    List<String> needDictTypeCodeList = new ArrayList<>(dictType2FiledCodeMap.keySet());
    Map<String, List<DictDataVo>> dictTypeCodeList =
        this.dictDataVoService.findByDictTypeCodeList(needDictTypeCodeList);
    for (Entry<String, List<DictDataVo>> entry : dictTypeCodeList.entrySet()) {
      String key = entry.getKey();
      Map<String, String> dictMap = entry.getValue().parallelStream()
          .filter(row -> {
            return "009".equals(row.getEnableStatus());
          })
          .collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
      String fieldName = dictType2FiledCodeMap.get(key);
      allDictCodeMap.put(fieldName, dictMap);
    }
    return allDictCodeMap;
  }
}
