package com.biz.crm.mdm.admin.web.exports.material.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

@Getter
@Setter
@CrmExcelExport
public class MaterialExportVo extends CrmExcelVo {

  /**
   * 物料编码
   */
  @CrmExcelColumn("物料编码")
  private String materialCode;

  /**
   * 物料名称
   */
  @CrmExcelColumn("物料名称")
  private String materialName;

  /**
   * 产品层级编码
   */
  @CrmExcelColumn("产品层级编码")
  private String productLevelCode;

  /**
   * 物料类型
   */
  @CrmExcelColumn("物料类型")
  private String materialType;

  /**
   * AI编码
   */
  @CrmExcelColumn("AI编码")
  private String aiCode;

  /**
   * 条形码
   */
  @CrmExcelColumn("商品条码")
  private String barCode;

  /**
   * 销售公司
   */
  @CrmExcelColumn("销售公司")
  private String saleCompany;


  /**
   * 单位体系名称
   */
  @CrmExcelColumn("单位体系名称")
  private String unitTypeName;

  /**
   * 成本价格
   */
  @CrmExcelColumn("成本价（元）")
  private String costPrice;

  /**
   * 数据业务状态（启用状态）
   */
  @CrmExcelColumn("启用状态")
  private String enableStatus;

  /**
   * 规格
   */
  @CrmExcelColumn("规格")
  private String specification;

  /**
   * 标准单位
   */
  @CrmExcelColumn("标准单位")
  private String standardUnit;

  /**
   * 箱码单位转换系数
   */
  @CrmExcelColumn("标箱换算系数")
  private BigDecimal caseUnitConversion;

  /**
   * 盒码单位转换系数
   */
  @CrmExcelColumn("标盒换算系数")
  private BigDecimal boxUnitConversion;

}
