package com.biz.crm.mdm.admin.web.exports.position.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 出口dto位置
 *
 * @author hefan
 * @date 2022/05/23
 */
@Data
public class PositionExportDto {

  private String tenantCode;

  private String delFlag;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 启用状态
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;

  /**
   * 职位级别编码
   */
  @ApiModelProperty("职位级别编码")
  private String positionLevelCode;

  /**
   * 职位级别名称
   */
  @ApiModelProperty("职位级别名称 ")
  private String positionLevelName;

  /**
   * 是否是主职位
   */
  @ApiModelProperty("是否是主职位")
  private Boolean primaryFlag;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgName;

  /**
   * 上级职位所属组织名称
   */
  @ApiModelProperty("上级职位所属组织名称")
  private String parentOrgName;

  /**
   * 用户姓名
   */
  @ApiModelProperty("用户姓名")
  private String fullName;

  /**
   * 用户账号
   */
  @ApiModelProperty("用户账号")
  private String userName;

  /**
   * 查询所有下级组织编码(查询这个组织及下级组织的数据)
   */
  @ApiModelProperty("组织编码(查询这个组织及下级组织的数据)")
  private String allUnderOrgCode;

  /**
   * 偏移量
   */
  private Integer offset;

  /**
   * limit
   */
  private Integer limit;
}
