package com.biz.crm.mdm.admin.web.exports.price.service;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.admin.web.exports.price.mapper.PriceExportsMapper;
import com.biz.crm.mdm.admin.web.exports.price.model.PriceCrmExportVo;
import com.biz.crm.mdm.admin.web.exports.price.model.PriceExportDto;
import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.biz.crm.mdm.business.price.local.entity.PriceType;
import com.biz.crm.mdm.business.price.local.service.PriceDimensionService;
import com.biz.crm.mdm.business.price.local.service.PriceTypeService;
import com.biz.crm.mdm.business.price.sdk.enums.EffectiveStatusEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceDimensionContainerService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;

/**
 * @author HanJiaJun
 * @describe: 价格维护导出
 * @createTime 2022年05月24日 19:05:00
 */
@Component
public class PriceExportProcess implements ExportProcess<PriceCrmExportVo> {

  @Autowired(required = false)
  private PriceExportsMapper priceExportsMapper;

  @Autowired(required = false)
  private PriceDimensionService priceDimensionService;

  @Autowired(required = false)
  private PriceTypeService priceTypeService;

  @Autowired(required = false)
  private PriceDimensionContainerService priceDimensionContainerService;


  @Override
  public Integer getTotal(Map<String, Object> params) {
    PriceExportDto testDataDto = this.findTestDataDto(params);
    return this.priceExportsMapper.getExportTotal(testDataDto);
  }

  @Override
  @Transactional /* 必须加上事务，否则导出的数据视图将会失效 */
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    final PriceExportDto dto = this.findTestDataDto(params);
    dto.setOffset(this.getPageSize() * vo.getPageNo());
    dto.setLimit(vo.getPageSize());
    List<PriceCrmExportVo> data = this.priceExportsMapper.findData(dto);
    if (CollectionUtils.isEmpty(data)) {
      return null;
    } else {
      Set<String> codes = data.stream().map(PriceCrmExportVo::getPriceCode).collect(Collectors.toSet());
      Map<String, PriceCrmExportVo> map = data.stream().collect(Collectors.toMap(PriceCrmExportVo::getPriceCode, v -> v, (v1, v2) -> v1));
      List<PriceDimension> list =
          priceDimensionService.findByPriceCodes(Lists.newArrayList(codes));
      for (PriceDimension priceDimension : list) {
        String priceCode = priceDimension.getPriceCode();
        String dimensionCode = priceDimension.getDimensionCode();
        String relateName = priceDimension.getRelateName();
        String relateCode = priceDimension.getRelateCode();
        //渠道
            if (dimensionCode.equals(PriceDimensionEnum.CHANNEL.getDictCode())) {
              PriceCrmExportVo priceCrmExportVo = map.get(priceCode);
              if (Objects.nonNull(priceCrmExportVo)) {
                priceCrmExportVo.setChannelName(relateName);
              }
            }
            //客户
            if (dimensionCode.equals(PriceDimensionEnum.CUSTOMER.getDictCode())) {
              PriceCrmExportVo priceCrmExportVo = map.get(priceCode);
              if (Objects.nonNull(priceCrmExportVo)) {
                priceCrmExportVo.setCustomerName(relateName);
              }
            }
            //组织
            if (dimensionCode.equals(PriceDimensionEnum.ORG.getDictCode())) {
              PriceCrmExportVo priceCrmExportVo = map.get(priceCode);
              if (Objects.nonNull(priceCrmExportVo)) {
                priceCrmExportVo.setOrgName(relateName);
              }
            }
            //终端
            if (dimensionCode.equals(PriceDimensionEnum.TERMINAL.getDictCode())) {
              PriceCrmExportVo priceCrmExportVo = map.get(priceCode);
              if (Objects.nonNull(priceCrmExportVo)) {
                priceCrmExportVo.setTerminalName(relateName);
              }
            }
            //价格组
            if (dimensionCode.equals(PriceDimensionEnum.PRICE_GROUP.getDictCode())) {
              PriceCrmExportVo priceCrmExportVo = map.get(priceCode);
              if (Objects.nonNull(priceCrmExportVo)) {
                priceCrmExportVo.setPriceGroupName(relateName);
              }
            }
            //商品
        if (dimensionCode.equals(PriceDimensionEnum.PRODUCT.getDictCode())) {
          PriceCrmExportVo priceCrmExportVo = map.get(priceCode);
          if (Objects.nonNull(priceCrmExportVo)) {
            priceCrmExportVo.setProductName(relateName);
            priceCrmExportVo.setProductCode(relateCode);
          }
        }
      }
      List<PriceCrmExportVo> res = map.values().stream().collect(Collectors.toList());
      //判断过期
      for (PriceCrmExportVo exportVo : res) {
        String effectiveStatus = this.findEffectiveStatus(exportVo);
        exportVo.setEffectiveStatus(effectiveStatus);
        exportVo.setEffectiveStatusName(EffectiveStatusEnum.getDesc(effectiveStatus));
        exportVo.setEnableStatusName(EnableStatusEnum.getDesc(exportVo.getEnableStatus()));
        PriceType detailByTypeCode = this.priceTypeService.findDetailByTypeCode(exportVo.getTypeCode());
        if (Objects.nonNull(detailByTypeCode)){
          exportVo.setTypeName(detailByTypeCode.getTypeName());
        }
        //查询维度名称
        String dimensionNameByTypeDetailCode = priceDimensionContainerService.findDimensionNameByTypeDetailCode(exportVo.getTypeDetailCode());
        exportVo.setTypeDetailName(dimensionNameByTypeDetailCode);
      }
      return toJSONArray(res);
    }
  }

  @Override
  public Class findCrmExcelVoClass() {
    return PriceCrmExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "MDM_PRICE_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "MDM价格维护信息导出";
  }


  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private PriceExportDto findTestDataDto(Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    final PriceExportDto dto = new PriceExportDto();
    final Object priceCode = params.get("priceCode");
    final Object typeCode = params.get("typeCode");
    final Object typeName = params.get("typeName");
    if (Objects.nonNull(priceCode)) {
      dto.setPriceCode(priceCode.toString());
    }
    if (Objects.nonNull(typeCode)) {
      dto.setTypeCode(typeCode.toString());
    }
    if (Objects.nonNull(typeName)) {
      dto.setTypeName(typeName.toString());
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    return dto;
  }

  /**
   * 判断是否过期
   *
   * @param price
   * @return
   */
  private String findEffectiveStatus(PriceCrmExportVo price) {
    if (Objects.isNull(price)
        || Objects.isNull(price.getBeginTime())
        || Objects.isNull(price.getEndTime())) {
      return EffectiveStatusEnum.DEFAULT.getDictCode();
    }
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Date nowDate = new Date();
    String now = sdf.format(nowDate);
    String begin =  price.getBeginTime();
    String end = price.getEndTime();
    if (begin.compareTo(now) > 0) {
      return EffectiveStatusEnum.DEFAULT.getDictCode();
    }
    if (begin.compareTo(now) <= 0 && end.compareTo(now) > 0) {
      return EffectiveStatusEnum.ACTIVE.getDictCode();
    }
    if (end.compareTo(now) <= 0) {
      return EffectiveStatusEnum.OVERDUE.getDictCode();
    }
    return EffectiveStatusEnum.DEFAULT.getDictCode();
  }
}
