package com.biz.crm.mdm.admin.web.exports.product.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@CrmExcelExport
public class ProductExportVo extends CrmExcelVo {

  /** 商品编码 */
  @CrmExcelColumn("商品编码")
  private String productCode;

  /** 商品名称 */
  @CrmExcelColumn("商品名称")
  private String productName;

  /** 产品层级编码 */
  @CrmExcelColumn("产品层级编码")
  private String productLevelCode;

  /** 商品类型 */
  @CrmExcelColumn("商品类型")
  private String productType;

  /** 销售单位 */
  @CrmExcelColumn("销售单位")
  private String saleUnit;

  /** 规格 */
  @CrmExcelColumn("规格")
  private String spec;

  /** 开始时间 */
  @CrmExcelColumn("开始时间")
  private String beginDateTime;

  /** 结束时间 */
  @CrmExcelColumn("结束时间")
  private String endDateTime;

  /** 上下架状态 */
  @CrmExcelColumn("上下架状态")
  private String isShelf;

  /** 启禁用状态 */
  @CrmExcelColumn("启禁用状态")
  private String enableStatus;

  /** 有无图片 */
  @CrmExcelColumn("是否维护图片")
  private String maintenancePicture;

  /** 有无详细内容 */
  @CrmExcelColumn("是否维护详情")
  private String maintenanceIntroduction;
}
