package com.biz.crm.mdm.admin.web.login;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * CRM体系的系统中，都可以使用的用户登录策略的公共方法
 *
 * @author pengxi
 */
@Component
public abstract class DefaultPerfectLoginUserDetails {

  @Autowired(required = false)
  @Lazy
  private UserPositionVoService userPositionVoService;

  @Autowired(required = false)
  @Lazy
  private PositionVoService positionVoService;

  @Autowired(required = false)
  @Lazy
  private OrgPositionVoService orgPositionVoService;

  /**
   * 完善登录信息中的用户基本信息
   *
   * @param currentUser 查询出的当前用户
   * @param loginUserDetails 登录用户信息
   */
  protected void perfectLoginUserDetails(UserVo currentUser, FacturerUserDetails loginUserDetails){
    // u-企业用户，c-客户用户，terminal-终端用户，customer_employee-经销商员工用户
    loginUserDetails.setIdentityType(currentUser.getUserType());
    loginUserDetails.setTenantCode(currentUser.getTenantCode());
    loginUserDetails.setUsername(currentUser.getUserName());
    loginUserDetails.setPhone(currentUser.getUserPhone());
    loginUserDetails.setRealName(currentUser.getFullName());
    loginUserDetails.setAccount(currentUser.getUserName());
    loginUserDetails.setPassword(currentUser.getUserPassword());
  }

  /**
   * 完善登录信息中的岗位组织等信息
   *
   * 一、获取当前职位，优先级顺序：
   *     1、第一优先获取用户职位关系表“是否当前职位”为是的职位
   *     2、第二优先获取用户职位关系表“是否主职位”为是的职位
   * 二、获取当前职位对应组织
   *
   * @param loginUserDetails 登录用户信息
   */
  protected void perfectLoginPostAndOrg(FacturerUserDetails loginUserDetails){
    List<UserPositionVo> userPositionVos = this.userPositionVoService.findByUserName(loginUserDetails.getTenantCode(), loginUserDetails.getAccount());
    if (CollectionUtils.isEmpty(userPositionVos)) {
      return;
    }
    // 一、1、取设定在数据库中的“当前岗位”
    Optional<UserPositionVo> currentFlagVo = userPositionVos.stream()
        .filter(r-> Boolean.TRUE.equals(r.getCurrentFlag()))
        .findFirst();
    if (currentFlagVo.isPresent()) {
      UserPositionVo userPositionVo = currentFlagVo.get();
      loginUserDetails.setPostCode(userPositionVo.getPositionCode());
    } else {
      // 一、2、去当前数据库中的“默认岗位”
      Optional<UserPositionVo> primaryFlagVo = userPositionVos.stream()
          .filter(r-> Boolean.TRUE.equals(r.getPrimaryFlag()))
          .findFirst();
      if (primaryFlagVo.isPresent()) {
        UserPositionVo userPositionVo = primaryFlagVo.get();
        loginUserDetails.setPostCode(userPositionVo.getPositionCode());
      }
    }
    // 完善职位信息
    if (StringUtils.isBlank(loginUserDetails.getPostCode())) {
      return;
    }
    // 当前用户所有岗位编码集合
    loginUserDetails.setPostCodes(userPositionVos.stream().map(UserPositionVo::getPositionCode).distinct().collect(Collectors.toList()));
    // 当前用户所有下级岗位编码集合
    List<PositionVo> childrenPositionList = this.positionVoService.findAllChildrenByCode(loginUserDetails.getPostCode());
    childrenPositionList = Optional.ofNullable(childrenPositionList).orElse(Lists.newLinkedList());
    List<String> childrenPostCodes = childrenPositionList.stream()
        .map(PositionVo::getPositionCode).distinct().collect(Collectors.toList());
    loginUserDetails.setChildrenPostCodes(childrenPostCodes);
    // 下面是查当前用户当前岗位对应角色及组织
    List<PositionVo> positionVoList = positionVoService.findByIdsOrCodes(null, Lists.newArrayList(loginUserDetails.getPostCode()));
    if (CollectionUtils.isEmpty(positionVoList)) {
      return;
    }
    PositionVo positionVo = positionVoList.get(0);
    loginUserDetails.setPostName(positionVo.getPositionName());
    if (CollectionUtils.isNotEmpty(positionVo.getRoleList())) {
      loginUserDetails.setRoleCodes(positionVo.getRoleList().toArray(new String[] {}));
    }
    // 二、
    OrgVo orgVo = this.orgPositionVoService.findByPositionCode(loginUserDetails.getPostCode());
    if (orgVo == null) {
      return;
    }
    loginUserDetails.setOrgCode(orgVo.getOrgCode());
    loginUserDetails.setOrgName(orgVo.getOrgName());
  }

}
