package com.biz.crm.mdm.admin.web.login.decision;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.mdm.admin.web.login.DefaultPerfectLoginUserDetails;
import com.biz.crm.mdm.business.user.sdk.service.UserValidityCheckService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.security.local.loginform.SimpleLoginFormDetails;
import com.bizunited.nebula.security.sdk.login.AuthenticationDecisionStrategy;
import com.bizunited.nebula.security.sdk.login.DecisionTypes;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

import java.nio.charset.StandardCharsets;

/**
 * 手机号 + 密码方式策略实现
 *
 * @author pengxi
 */
@Component
public class DefaultPhoneAndPasswordStrategy extends DefaultPerfectLoginUserDetails implements AuthenticationDecisionStrategy {

  @Autowired(required = false)
  private UserValidityCheckService userValidityCheckService;

  @Override
  public Integer type() {
    return DecisionTypes.PHONEANDPASSWORD.getCode();
  }

  @Override
  public UserIdentity decide(LoginDetails loginFormDetails, Integer type) {
    /*
     * 处理过程如下：
     * 1、首先通过手机号查询当前用户并检查用户有效性
     * 2、检查登录密码是否正确
     * 3、填充security鉴权必要信息：tenantCode,account,password
     * 4、然后完善登录信息中的用户基本信息
     * 5、最后完善登录信息中的岗位组织等信息
     */
    SimpleLoginFormDetails loginUserDetails = (SimpleLoginFormDetails) loginFormDetails;
    Validate.notBlank(loginUserDetails.getPhone(), "登录手机号不能为空！");
    Validate.notBlank(loginUserDetails.getPassword(), "登录密码不能为空！");
    // 1、
    UserVo userVo = this.userValidityCheckService.verificationManageByPhone(loginUserDetails.getPhone());
    // 2、密码校验过程先按与前端约定的加密方式做解密，然后md5再做校验
    String passwordEncryption = DigestUtils.md5DigestAsHex(loginUserDetails.getPassword().getBytes(StandardCharsets.UTF_8));
    Validate.isTrue(passwordEncryption.equals(userVo.getUserPassword()), "登录密码错误！");
    // 3、4、
    FacturerUserDetails mdmUser = new FacturerUserDetails();
    mdmUser.setLoginType(DecisionTypes.PHONEANDPASSWORD.getCode());
    super.perfectLoginUserDetails(userVo, mdmUser);
    mdmUser.setAccount(userVo.getUserName());
    // 5、
    super.perfectLoginPostAndOrg(mdmUser);
    return mdmUser;
  }
}
