package com.biz.crm.mdm.admin.web.login.refresh;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.refresh.AuthenticationRefreshStrategy;

/**
 * 这是最后一个用户刷新的工作策略，使用CRM厂商用户性质的管理员用户作为当前线程用户上下文中的内容
 * @author yinwenjie
 */
@Component
public class DefaultAuthenticationRefreshStrategy implements AuthenticationRefreshStrategy {

  @Autowired
  private SimpleSecurityProperties simpleSecurityProperties;
  
  @Override
  public int getOrder() {
    // 当然是最后一个工作
    return Integer.MAX_VALUE;
  }

  @Override
  public boolean matched(Object info) {
    return true;
  }

  @Override
  public UserIdentity refresh(Object userInfo) {
    String[] roleCodes = this.simpleSecurityProperties.getIndependencyRoles();
    String userAccount = this.simpleSecurityProperties.getIndependencyUser();
    FacturerUserDetails facturer = new FacturerUserDetails();
    facturer.setAccount(userAccount);
    // 厂商用户
    facturer.setIdentityType("u");
    facturer.setRoleCodes(roleCodes);
    facturer.setTenantCode(TenantUtils.getTenantCode());
    return facturer;
  }

}
