package com.biz.crm.mdm.admin.web.notifier;

import com.biz.crm.mdm.admin.web.service.PositionRoleVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.bizunited.nebula.security.sdk.event.AuthenticationUserEventListener;
import com.google.common.collect.Sets;

import java.util.List;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 获取当前登陆者所具备的角色（roleCode）
 * @author pengxi
 * @date  2021/12/07
 */
@Component("AuthenticationUserEventListenerImpl")
public class AuthenticationUserEventListenerImpl implements AuthenticationUserEventListener {

  @Autowired(required = false)
  private PositionRoleVoService positionRoleVoService;

  @Override
  public Set<String> onRequestRoleCodes(String tenantCode, String account) {
    if (StringUtils.isBlank(tenantCode) || StringUtils.isBlank(account)) {
      return Sets.newHashSet();
    }
    List<PositionVo> positionVos = positionRoleVoService.findByAccount(tenantCode, account);
    if (CollectionUtils.isEmpty(positionVos)) {
      return Sets.newHashSet();
    }
    Set<String> roleCodes = Sets.newHashSet();
    positionVos.forEach(p->{
      if (!CollectionUtils.isEmpty(p.getRoleList())) {
        roleCodes.addAll(p.getRoleList());
      }
    });
    return roleCodes;
  }
}

