package com.biz.crm.mdm.admin.web.position.controller;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionDto;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.security.sdk.AuthenticationJwtTokenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

/**
 * 重新获取Jwt
 * 
 * @author Ken
 * @version 1.0 Copyright 2022年12月14日 下午7:30:55
 */
@Slf4j
@Api(tags = {"重新获取Jwt"})
@RestController
@RequestMapping(path = {"/v1/mdmAdminWeb/mdmJwt", "/v1/position/mdmJwt"})
public class MdmJwtController extends BaseController {
  @Autowired(required = false)
  private LoginUserService              loginUserService;
  @Autowired(required = false)
  private AuthenticationJwtTokenService authenticationJwtTokenService;
  
  /**
   * 更新用户当前职位
   * 
   * @param dto
   * @return
   */
  @ApiOperation(value = "更新用户当前职位,并返回JWT信息")
  @RequestMapping(value = "updateCurrentFlagPosition", method = {RequestMethod.PATCH, RequestMethod.POST})
  public Result<?> updateCurrentFlagPosition(@RequestBody UserPositionDto dto) {
    try {
      // 切换上下文中的当前职位及角色集合
      Authentication refreshAuthentication = this.loginUserService.refreshAuthentication(dto);
      System.out.println(refreshAuthentication.getAuthorities());
      // 重构JWT信息，返回给前端
      String rebuildJwt = authenticationJwtTokenService.rebuildJwt();
      Map<String, String> resultMap = new HashMap<>();
      resultMap.put("jwt", rebuildJwt);
      return Result.ok(resultMap);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
