package com.biz.crm.mdm.admin.web.report.customer.user.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.NoRelaCurCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.NoRelaCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.RelaCurCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.mapper.CustomerUserRRoleReportMapper;
import com.biz.crm.mdm.admin.web.report.customer.user.vo.CustomerUserRRoleReportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author sunx
 * @date 2021/11/12
 */
@Component
public class CustomerUserRRoleReportRepository {

  @Autowired(required = false)
  private CustomerUserRRoleReportMapper customerUserRRoleReportMapper;

  public Page<CustomerUserRRoleReportVo> findByRelaCurCustomerUserDto(
      Page<CustomerUserRRoleReportVo> page, RelaCurCustomerUserDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return customerUserRRoleReportMapper
        .findByRelaCurCustomerUserDto(page, dto);
  }

  public Page<CustomerUserRRoleReportVo> findByNoRelaCurCustomerUserDto(
      Page<CustomerUserRRoleReportVo> page, NoRelaCurCustomerUserDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return customerUserRRoleReportMapper
        .findByNoRelaCurCustomerUserDto(page, dto);
  }

  public Page<CustomerUserRRoleReportVo> findByNoRelaCustomerUserDto(
      Page<CustomerUserRRoleReportVo> page, NoRelaCustomerUserDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return customerUserRRoleReportMapper
        .findByNoRelaCustomerUserDto(page, dto);
  }
}
