package com.biz.crm.mdm.admin.web.report.customer.user.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.NoRelaCurCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.NoRelaCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.RelaCurCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.repository.CustomerUserRRoleReportRepository;
import com.biz.crm.mdm.admin.web.report.customer.user.service.CustomerUserRRoleReportVoService;
import com.biz.crm.mdm.admin.web.report.customer.user.vo.CustomerUserRRoleReportVo;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 客户用户关联角色
 *
 * @author sunx
 * @date 2021/11/12
 */
@Service
@Slf4j
public class CustomerUserRRoleReportVoServiceImpl implements CustomerUserRRoleReportVoService {

  @Autowired(required = false)
  private CustomerUserRRoleReportRepository customerUserRRoleReportRepository;

  @Override
  public Page<CustomerUserRRoleReportVo> findByRelaCurCustomerUserDto(
      Pageable pageable, RelaCurCustomerUserDto dto) {
    Validate.notNull(dto, "查询参数缺失");
    Validate.notBlank(dto.getRoleCode(), "角色编码不能为空");
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    Page<CustomerUserRRoleReportVo> page = new Page<>(pageable.getPageNumber(),
        pageable.getPageSize());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    Page<CustomerUserRRoleReportVo> pageResult = this.customerUserRRoleReportRepository
        .findByRelaCurCustomerUserDto(page, dto);
    return pageResult;
  }

  @Override
  public Page<CustomerUserRRoleReportVo> findByNoRelaCurCustomerUserDto(
      Pageable pageable, NoRelaCurCustomerUserDto dto) {
    Validate.notNull(dto, "查询参数缺失");
    Validate.notBlank(dto.getRoleCode(), "角色编码不能为空");
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    Page<CustomerUserRRoleReportVo> page = new Page<>(pageable.getPageNumber(),
        pageable.getPageSize());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    Page<CustomerUserRRoleReportVo> pageResult = this.customerUserRRoleReportRepository
        .findByNoRelaCurCustomerUserDto(page, dto);
    return pageResult;
  }

  @Override
  public Page<CustomerUserRRoleReportVo> findByNoRelaCustomerUserDto(
      Pageable pageable, NoRelaCustomerUserDto dto) {
    Validate.notNull(dto, "查询参数缺失");
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    Page<CustomerUserRRoleReportVo> page = new Page<>(pageable.getPageNumber(),
        pageable.getPageSize());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    Page<CustomerUserRRoleReportVo> pageResult = this.customerUserRRoleReportRepository
        .findByNoRelaCustomerUserDto(page, dto);
    return pageResult;
  }
}
