package com.biz.crm.mdm.admin.web.report.customer.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.business.common.sdk.vo.WorkflowFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 客户分页返回vo
 *
 * @author ning.zhang
 * @date 2021/11/10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户分页返回vo")
public class CustomerPageVo extends WorkflowFlagOpVo {

  private static final long serialVersionUID = 5323221664981825624L;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;
  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;
  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  private String customerType;
  /**
   * 所属客户组织编码
   */
  @ApiModelProperty("所属客户组织编码")
  private String customerOrgCode;
  /**
   * 所属客户组织名称
   */
  @ApiModelProperty("所属客户组织名称")
  private String customerOrgName;

  /**
   * 所属企业组织编码
   */
  @ApiModelProperty("所属企业组织编码")
  private String orgCode;
  /**
   * 所属企业组织名称
   */
  @ApiModelProperty("所属企业组织名称")
  private String orgName;
  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;
  /**
   * 市级编码
   */
  @ApiModelProperty("市级编码")
  private String cityCode;
  /**
   * 区级编码
   */
  @ApiModelProperty("区级编码")
  private String districtCode;
  /**
   * 省级编码
   */
  @ApiModelProperty("省级编码")
  private String provinceCode;
  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;
  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  private String districtName;
  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;
  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  private String actApproveStatus;
  /**
   * 锁定状态：009正常，003冻结
   */
  @ApiModelProperty("锁定状态：009正常，003冻结")
  private String lockState;
  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;
  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 客户等级
   */
  @ApiModelProperty("客户等级")
  private String customerLevel;

  /**
   * 上级经销商编码
   */
  @ApiModelProperty("上级经销商编码")
  private String parentCustomerCode;

  /**
   * 上级经销商名称
   */
  @ApiModelProperty("上级经销商名称")
  private String parentCustomerName;

  /**
   * 标签集合
   */
  @ApiModelProperty("标签集合")
  private Set<String> tags;

  /**
   * 注册地址
   */
  @ApiModelProperty("注册地址")
  private String registeredAddress;
}
