package com.biz.crm.mdm.admin.web.report.position.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 职位报表常量类
 *
 * @author ning.zhang
 * @date 2022/3/29
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class PositionReportConstant {

  /**
   * 职位分页来源-职位分页列表
   */
  public static final String POSITION_PAGE_SOURCE_POSITION_LIST = "position_list";

  /**
   * 职位分页来源-职位关联下属职位分页列表
   */
  public static final String POSITION_PAGE_SOURCE_CHILD_POSITION_LIST = "child_position_list";

  /**
   * 职位分页来源-职位级别关联职位分页列表
   */
  public static final String POSITION_PAGE_SOURCE_LEVEL_POSITION_LIST = "level_position_list";

  /**
   * 职位分页来源-组织关联职位分页列表
   */
  public static final String POSITION_PAGE_SOURCE_ORG_POSITION_LIST = "org_position_list";

  /**
   * 职位分页来源-职位下拉框分页列表
   */
  public static final String POSITION_PAGE_SOURCE_SELECT_POSITION_LIST = "select_position_list";

  /**
   * 职位分页来源-已关联当前角色的职位分页列表
   */
  public static final String POSITION_PAGE_SOURCE_HAS_RELATE_CURRENT_ROLE_POSITION_LIST = "has_relate_current_role_position_list";

  /**
   * 职位分页来源-未关联当前角色的职位分页列表
   */
  public static final String POSITION_PAGE_SOURCE_NOT_RELATE_CURRENT_ROLE_POSITION_LIST = "not_relate_current_role_position_list";

  /**
   * 职位分页来源-未关联任何角色的职位分页列表
   */
  public static final String POSITION_PAGE_SOURCE_NOT_RELATE_ANY_ROLE_POSITION_LIST = "not_relate_any_role_position_list";

  /**
   * 职位分页来源-用户职位下拉框分页列表
   */
  public static final String POSITION_PAGE_SOURCE_USER_SELECT_POSITION_LIST = "user_select_position_list";

  /**
   * 职位分页来源-用户父级职位下拉框分页列表
   */
  public static final String POSITION_PAGE_SOURCE_USER_SELECT_PARENT_POSITION_LIST = "user_select_parent_position_list";

  /**
   * 职位分页来源-上级职位分页列表
   */
  public static final String POSITION_PAGE_SOURCE_PARENT_POSITION_LIST = "parent_position_list";

}
