package com.biz.crm.mdm.admin.web.report.position.dto;

import com.biz.crm.mdm.admin.web.report.position.constant.PositionReportConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 组织关联职位列表查询条件Dto
 *
 * @author ning.zhang
 * @date 2021/11/4
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织关联职位列表查询条件Dto", description = "组织关联职位列表查询条件Dto")
public class OrgPositionPageDto extends AbstractPositionPageDto {

  /**
   * 当前组织编码
   */
  @ApiModelProperty("当前组织编码")
  private String thisOrgCode;
  /**
   * 组织编码(查询这个组织及下级组织的数据)
   */
  @ApiModelProperty("组织编码(查询这个组织及下级组织的数据)")
  private String allUnderThisOrgCode;
  /**
   * 用户姓名
   */
  @ApiModelProperty("用户姓名")
  private String fullName;
  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;
  /**
   * 职位级别编码
   */
  @ApiModelProperty("职位级别编码")
  private String positionLevelCode;

  /**
   * 分页来源
   */
  @ApiModelProperty(value = "分页来源", hidden = true)
  private String pageSource = PositionReportConstant.POSITION_PAGE_SOURCE_ORG_POSITION_LIST;

}
