package com.biz.crm.mdm.admin.web.report.position.dto;

import com.biz.crm.mdm.admin.web.report.position.constant.PositionReportConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 职位下拉框查询条件Dto
 *
 * @author ning.zhang
 * @date 2021/11/4
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位下拉框查询条件Dto", description = "职位下拉框查询条件Dto")
public class SelectPositionPageDto extends AbstractPositionPageDto {

  /**
   * 组织名称/职位名称/用户名称
   */
  @ApiModelProperty("组织名称/职位名称/用户名称")
  private String unionName;

  /**
   * 回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据
   */
  @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
  private List<String> selectedCodes;

  /**
   * 组织编码（排除这个组织编码（不含自己）的全部下级组织）
   */
  @ApiModelProperty("组织编码（排除这个组织编码（不含自己）的全部下级组织对应的职位）")
  private String notUnderThisOrgCodeExcludeSelf;

  /**
   * 职位编码（排除当前职位及下级职位）
   */
  @ApiModelProperty("职位编码（排除当前职位及下级职位）")
  private String notUnderThisPositionCode;
  /**
   * 启用状态
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;
  /**
   * 分页来源
   */
  @ApiModelProperty(value = "分页来源",hidden = true)
  private String pageSource = PositionReportConstant.POSITION_PAGE_SOURCE_SELECT_POSITION_LIST;
}
