package com.biz.crm.mdm.admin.web.report.position.strategy.impl;

import com.biz.crm.mdm.admin.web.report.position.constant.PositionReportConstant;
import com.biz.crm.mdm.admin.web.report.position.dto.LevelPositionPageDto;
import com.biz.crm.mdm.admin.web.report.position.strategy.PositionReportStrategy;
import com.biz.crm.mdm.admin.web.report.position.strategy.helper.PositionReportStrategyHelper;
import com.biz.crm.mdm.admin.web.report.position.vo.PositionPageVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 职位级别关联职位分页列表报表数据策略实现
 *
 * @author ning.zhang
 * @date 2022/3/29
 */
@Component
public class LevelPositionReportStrategyImpl implements PositionReportStrategy<LevelPositionPageDto> {

  @Autowired(required = false)
  private PositionReportStrategyHelper positionReportStrategyHelper;

  @Override
  public String getPageSource() {
    return PositionReportConstant.POSITION_PAGE_SOURCE_LEVEL_POSITION_LIST;
  }

  @Override
  public Boolean onRequest(LevelPositionPageDto dto) {
    return StringUtils.isNotBlank(dto.getThisPositionLevelCode());
  }

  @Override
  public void onReturn(List<PositionPageVo> voList) {
    this.positionReportStrategyHelper.buildUnionName(voList);
  }
}
