package com.biz.crm.mdm.admin.web.report.positionlevel.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.admin.web.report.positionlevel.dto.PositionLevelPageDto;
import com.biz.crm.mdm.admin.web.report.positionlevel.service.PositionLevelPageVoService;
import com.biz.crm.mdm.admin.web.report.positionlevel.vo.PositionLevelPageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 职位级别管理: PositionLevelPageVo: 职位级别列表相关
 *
 * @author ning.zhang
 * @date 2021/11/4
 */
@Slf4j
@RestController
@RequestMapping("/v1/positionLevel/positionLevel")
@Api(tags = "职位级别管理: PositionLevelPageVo: 职位级别列表相关")
public class PositionLevelPageVoController {

  @Autowired
  private PositionLevelPageVoService positionLevelPageVoService;

  /**
   * 职位级别分页列表(报表查询)
   *
   * @param pageable 分页参数
   * @param dto      参数dto
   * @return 职位级别列表
   */
  @ApiOperation(value = "职位级别分页列表(报表查询)")
  @GetMapping("/findByPositionLevelPageDto")
  public Result<Page<PositionLevelPageVo>> findByPositionLevelPageDto(@PageableDefault(50) Pageable pageable,
                                                            @ApiParam(name = "PositionLevelPageDto", value = "分页Dto") PositionLevelPageDto dto) {
    try {
      return Result.ok(this.positionLevelPageVoService.findByPositionLevelPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
