package com.biz.crm.mdm.admin.web.report.product.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 商品report分页查询dto
 *
 * @author sunx
 * @date 2021/11/4
 */
@Data
@ApiModel(value = "ProductReportPaginationDto", description = "商品report分页查询dto")
public class ProductReportPaginationDto {

  @ApiModelProperty("商品编码")
  private String productCode;

  @ApiModelProperty("商品名称")
  private String productName;

  @ApiModelProperty("商品编码或者名称")
  private String productCodeOrName;

  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  @ApiModelProperty("商品类型")
  private String productType;

  @ApiModelProperty("上下架状态")
  private String isShelf;

  @ApiModelProperty("启禁用状态")
  private String enableStatus;

  @ApiModelProperty("是否维护图片")
  private Boolean maintenancePicture;

  @ApiModelProperty("是否维护详情")
  private Boolean maintenanceIntroduction;

  @ApiModelProperty("销售单位")
  private String saleUnit;

  @ApiModelProperty(value = "删除标记", hidden = false)
  private String delFlag;

  @ApiModelProperty(value = "租户编码", hidden = false)
  private String tenantCode;

  @ApiModelProperty(value = "商品层级rule_code", hidden = false)
  private String productLevelRuleCode;

  /**
   * 客户编码-传了客户编码和客户类型会去询价
   */
  @ApiModelProperty("客户编码-传了客户编码和客户类型会去询价")
  private String clientCode;

  /**
   * 客户类型-传了客户编码和客户类型会去询价
   *
   * @see com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum
   */
  @ApiModelProperty("客户类型-传了客户编码和客户类型会去询价")
  private String clientType;
}
