package com.biz.crm.mdm.admin.web.report.product.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.product.dto.ProductReportPaginationDto;
import com.biz.crm.mdm.admin.web.report.product.repository.ProductReportVoRepository;
import com.biz.crm.mdm.admin.web.report.product.service.ProductReportVoService;
import com.biz.crm.mdm.admin.web.report.product.vo.ProductReportMediaVo;
import com.biz.crm.mdm.admin.web.report.product.vo.ProductReportVo;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.local.entity.ProductMedia;
import com.biz.crm.mdm.business.product.local.service.ProductMediaService;
import com.biz.crm.mdm.business.product.sdk.enums.MediaTypeEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author sunx
 * @date 2021/11/4
 */
@Service
public class ProductReportVoServiceImpl implements ProductReportVoService {

  @Autowired(required = false)
  private ProductReportVoRepository productReportVoRepository;

  @Autowired(required = false)
  private ProductLevelVoSdkService productLevelVoSdkService;
  @Autowired
  private PriceModelVoService priceModelVoService;
  @Autowired
  private ProductMediaService productMediaService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<ProductReportVo> findByConditions(Pageable pageable,
                                                ProductReportPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    Page<ProductReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());

    if (StringUtils.isNotBlank(dto.getProductLevelCode())) {
      ProductLevelVo productLevelVo = productLevelVoSdkService
          .findDetailsByCode(dto.getProductLevelCode());
      if (Objects.nonNull(productLevelVo)) {
        dto.setProductLevelRuleCode(productLevelVo.getRuleCode());
      }
    }
    Page<ProductReportVo> pageResult = productReportVoRepository.findByConditions(page, dto);
    List<ProductReportVo> records = pageResult.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return pageResult;
    }
    Set<String> productCodeSet = records.stream().map(ProductReportVo::getProductCode).collect(Collectors.toSet());
    List<ProductMedia> mediaList =
        productMediaService.findByProductCodes(Lists.newArrayList(productCodeSet));

    if (org.apache.commons.collections.CollectionUtils.isEmpty(mediaList)) {
      return pageResult;
    }
    List<ProductReportMediaVo> voList =
        (List<ProductReportMediaVo>)
            this.nebulaToolkitService.copyCollectionByWhiteList(
                mediaList,
                ProductMedia.class,
                ProductReportMediaVo.class,
                HashSet.class,
                ArrayList.class);
    Map<String, List<ProductReportMediaVo>> map =
        voList.stream().collect(Collectors.groupingBy(ProductReportMediaVo::getType));
    Map<String, List<ProductReportMediaVo>> mapPictureMedia =
        map.getOrDefault(MediaTypeEnum.PICTURE.getCode(), Lists.newArrayList()).stream()
            .collect(Collectors.groupingBy(ProductReportMediaVo::getProductCode));
    Map<String, List<ProductReportMediaVo>> mapVideoMedia =
        map.getOrDefault(MediaTypeEnum.VIDEO.getCode(), Lists.newArrayList()).stream()
            .collect(Collectors.groupingBy(ProductReportMediaVo::getProductCode));
    for (ProductReportVo item : records) {
      item.setPictureMediaList(mapPictureMedia.get(item.getProductCode()));
      item.setVideoMediaList(mapVideoMedia.get(item.getProductCode()));
    }
    this.buildPrice(pageResult.getRecords(), dto);
    return pageResult;
  }

  /**
   * 构建终端产品价格
   *
   * @param products
   * @param dto
   */
  private void buildPrice(List<ProductReportVo> products, ProductReportPaginationDto dto) {
    if (CollectionUtils.isEmpty(products) || StringUtils.isAnyBlank(dto.getClientCode(), dto.getClientType())) {
      return;
    }
    FindPriceDto priceDto = new FindPriceDto();
    priceDto.setUserType(dto.getClientType());
    priceDto.setUserCode(dto.getClientCode());
    priceDto.setProductCodeSet(products.stream().map(ProductReportVo::getProductCode).collect(Collectors.toSet()));
    Map<String, PriceModelVo> priceModelMap = this.priceModelVoService.findPrice(priceDto);
    if (Objects.isNull(priceModelMap)) {
      return;
    }
    products.forEach(productReportVo ->
        productReportVo.setPrice(priceModelMap.getOrDefault(productReportVo.getProductCode(), new PriceModelVo()).getPrice()));
  }
}
