package com.biz.crm.mdm.admin.web.report.spu.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.admin.web.report.spu.dto.VisitorProductSpuPaginationDto;
import com.biz.crm.mdm.admin.web.report.spu.service.VisitorProductSpuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商品SPU管理: ProductSpuVo: 商品SPU管理电商游客访问分页数据
 *
 * @author pengxi
 * @date 2022/9/9
 */
@Slf4j
@Api(tags = "商品SPU管理: ProductSpuVo: 商品SPU管理电商游客访问分页数据")
@RestController
@RequestMapping(value = {"/v1/product/spu/visitor"})
public class VisitorProductSpuVoController {

  @Autowired(required = false)
  private VisitorProductSpuVoService visitorProductSpuVoService;

  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<ProductSpuVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                     @ApiParam(name = "order", value = "商品spu信息分页查询dto") VisitorProductSpuPaginationDto dto) {
    try {
      Page<ProductSpuVo> result = this.visitorProductSpuVoService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
